/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.PlayLandAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.RestrictionEffect;
import mage.cards.Card;
import mage.cards.w.WordOfCommandCantActivateEffect;
import mage.cards.w.WordOfCommandTestFlashEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.ManaPool;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class WordOfCommandEffect
extends OneShotEffect {
    WordOfCommandEffect() {
        super(Outcome.GainControl);
        this.staticText = "Look at target opponent's hand and choose a card from it. You control that player until {this} finishes resolving. The player plays that card if able. While doing so, the player can activate mana abilities only if they're from lands that player controls and only if mana they produce is spent to activate other mana abilities of lands the player controls and/or to play that card. If the chosen card is cast as a spell, you control the player while that spell is resolving";
    }

    private WordOfCommandEffect(WordOfCommandEffect effect) {
        super((OneShotEffect)effect);
    }

    public WordOfCommandEffect copy() {
        return new WordOfCommandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player sourceController = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        MageObject sourceObject = game.getObject(source);
        Card card = null;
        if (sourceController != null && targetPlayer != null && sourceObject != null) {
            Player controller = null;
            Spell wordOfCommand = game.getSpell(source.getSourceId());
            if (wordOfCommand != null) {
                controller = wordOfCommand.getCommandedByPlayerId() != null ? game.getPlayer(wordOfCommand.getCommandedByPlayerId()) : game.getPlayer(sourceController.getTurnControlledBy());
            }
            if (controller == null) {
                controller = sourceController;
            }
            TargetCard targetCard = new TargetCard(Zone.HAND, new FilterCard());
            if (controller.choose(Outcome.Discard, targetPlayer.getHand(), targetCard, source, game)) {
                card = game.getCard(targetCard.getFirstTarget());
            }
            CardUtil.takeControlUnderPlayerStart((Game)game, (Ability)source, (Player)controller, (Player)targetPlayer, (boolean)true);
            if (card != null) {
                Object spellAbility;
                WordOfCommandCantActivateEffect effect = new WordOfCommandCantActivateEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(targetPlayer.getId()));
                game.addEffect((ContinuousEffect)effect, source);
                ManaPool manaPool = targetPlayer.getManaPool();
                manaPool.setForcedToPay(true);
                manaPool.storeMana();
                int bookmark = game.bookmarkState();
                boolean canPlay = this.checkPlayability(card, targetPlayer, game, source);
                while (canPlay && targetPlayer.canRespond() && !targetPlayer.playCard(card, game, false, new ApprovingObject(source, game)) && (spellAbility = card.getSpellAbility()) != null) {
                    spellAbility.clearManaCostsToPay();
                    spellAbility.addManaCostsToPay((ManaCost)spellAbility.getManaCosts());
                    ((ManaCostsImpl)spellAbility.getManaCostsToPay()).forceManaRollback(game, manaPool);
                    canPlay = this.checkPlayability(card, targetPlayer, game, source);
                }
                if (!canPlay) {
                    game.informPlayers(targetPlayer.getLogName() + " didn't play " + card.getLogName() + " (card can't be played)");
                }
                manaPool.setForcedToPay(false);
                manaPool = targetPlayer.getManaPool();
                manaPool.setForcedToPay(false);
                game.removeBookmark(bookmark);
                targetPlayer.resetStoredBookmark(game);
                for (RestrictionEffect eff : game.getContinuousEffects().getRestrictionEffects()) {
                    if (!(eff instanceof WordOfCommandCantActivateEffect)) continue;
                    eff.discard();
                    break;
                }
                game.getContinuousEffects().removeInactiveEffects(game);
                Spell spell = game.getSpell(card.getId());
                if (spell != null) {
                    spell.setCommandedBy(controller.getId(), CardUtil.getSourceLogName((Game)game, (Ability)source));
                }
            }
            if ((wordOfCommand = game.getSpell(source.getSourceId())) != null) {
                wordOfCommand.setCommandedBy(controller.getId(), CardUtil.getSourceLogName((Game)game, (Ability)source));
            } else {
                CardUtil.takeControlUnderPlayerEnd((Game)game, (Ability)source, (Player)controller, (Player)targetPlayer);
            }
            return true;
        }
        return false;
    }

    private boolean checkPlayability(Card card, Player targetPlayer, Game game, Ability source) {
        boolean canPlay;
        block3: {
            block4: {
                canPlay = false;
                if (!card.isLand(game)) break block4;
                if (!targetPlayer.canPlayLand() || !game.getActivePlayerId().equals(targetPlayer.getId())) break block3;
                for (Ability ability : card.getAbilities(game)) {
                    if (!(ability instanceof PlayLandAbility) || game.getContinuousEffects().preventedByRuleModification(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.PLAY_LAND, (UUID)ability.getSourceId(), (Ability)ability, (UUID)targetPlayer.getId()), ability, game, true)) continue;
                    canPlay = true;
                }
                break block3;
            }
            WordOfCommandTestFlashEffect effect2 = new WordOfCommandTestFlashEffect();
            game.addEffect((ContinuousEffect)effect2, source);
            if (targetPlayer.getPlayableObjects(game, Zone.HAND).containsObject(card.getId())) {
                canPlay = true;
            }
            for (AsThoughEffect eff : game.getContinuousEffects().getApplicableAsThoughEffects(AsThoughEffectType.CAST_AS_INSTANT, game)) {
                if (!(eff instanceof WordOfCommandTestFlashEffect)) continue;
                eff.discard();
                break;
            }
        }
        return canPlay;
    }
}

