/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.discard.DiscardEachPlayerEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class WordsOfWasteEffect
extends ReplacementEffectImpl {
    WordsOfWasteEffect() {
        super(Duration.EndOfTurn, Outcome.Discard);
        this.staticText = "The next time you would draw a card this turn, each opponent discards a card instead";
    }

    private WordsOfWasteEffect(WordsOfWasteEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public WordsOfWasteEffect copy() {
        return new WordsOfWasteEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            new DiscardEachPlayerEffect(TargetController.OPPONENT).apply(game, source);
            this.discard();
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }
}

