/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.BearToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class WordsOfWildingEffect
extends ReplacementEffectImpl {
    WordsOfWildingEffect() {
        super(Duration.EndOfTurn, Outcome.PutCreatureInPlay);
        this.staticText = "The next time you would draw a card this turn, create a 2/2 green Bear creature token instead";
    }

    private WordsOfWildingEffect(WordsOfWildingEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public WordsOfWildingEffect copy() {
        return new WordsOfWildingEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            new CreateTokenEffect((Token)new BearToken()).apply(game, source);
            this.discard();
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }
}

