/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.w.UntapDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.turn.TurnMod;

class WorldAtWarEffect
extends OneShotEffect {
    WorldAtWarEffect() {
        super(Outcome.Benefit);
        this.staticText = "After the second main phase this turn, there's an additional combat phase followed by an additional main phase. At the beginning of that combat, untap all creatures that attacked this turn";
    }

    private WorldAtWarEffect(WorldAtWarEffect effect) {
        super((OneShotEffect)effect);
    }

    public WorldAtWarEffect copy() {
        return new WorldAtWarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TurnMod combat = new TurnMod(source.getControllerId()).withExtraPhase(TurnPhase.COMBAT, TurnPhase.POSTCOMBAT_MAIN);
        game.getState().getTurnMods().add(combat);
        UntapDelayedTriggeredAbility delayedTriggeredAbility = new UntapDelayedTriggeredAbility();
        delayedTriggeredAbility.setConnectedTurnMod(combat.getId());
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedTriggeredAbility, source);
        return true;
    }
}

