/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class WorldgorgerDragonEntersEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("all other permanents you control");

    public WorldgorgerDragonEntersEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile all other permanents you control";
    }

    private WorldgorgerDragonEntersEffect(WorldgorgerDragonEntersEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        UUID exileId;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && (exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC())) != null) {
            LinkedHashSet cardsToExile = new LinkedHashSet();
            cardsToExile.addAll(game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game));
            controller.moveCardsToExile(cardsToExile, source, game, true, exileId, sourceObject.getIdName());
            return true;
        }
        return false;
    }

    public WorldgorgerDragonEntersEffect copy() {
        return new WorldgorgerDragonEntersEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

