/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class WorldheartPhoenixPlayEffect
extends AsThoughEffectImpl {
    WorldheartPhoenixPlayEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast {this} from your graveyard by paying {W}{U}{B}{R}{G} rather than paying its mana cost. If you do, it enters with two +1/+1 counters on it";
    }

    private WorldheartPhoenixPlayEffect(WorldheartPhoenixPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public WorldheartPhoenixPlayEffect copy() {
        return new WorldheartPhoenixPlayEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Player player;
        if (sourceId.equals(source.getSourceId()) && source.isControlledBy(affectedControllerId) && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD && (player = game.getPlayer(affectedControllerId)) != null) {
            player.setCastSourceIdWithAlternateMana(sourceId, (ManaCosts)new ManaCostsImpl("{W}{U}{B}{R}{G}"), null, MageIdentifier.WorldheartPhoenixAlternateCast);
            return true;
        }
        return false;
    }
}

