/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.DomainValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class WorldlyCounselEffect
extends OneShotEffect {
    WorldlyCounselEffect() {
        super(Outcome.DrawCard);
        this.staticText = "<i>Domain</i> &mdash; Look at the top X cards of your library, where X is the number of basic land types among lands you control. Put one of those cards into your hand and the rest on the bottom of your library in any order";
    }

    private WorldlyCounselEffect(WorldlyCounselEffect effect) {
        super((OneShotEffect)effect);
    }

    public WorldlyCounselEffect copy() {
        return new WorldlyCounselEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, DomainValue.REGULAR.calculate(game, source, (Effect)this)));
        controller.lookAtCards(source, null, (Cards)cards, game);
        if (!cards.isEmpty()) {
            if (cards.size() == 1) {
                controller.moveCards((Cards)cards, Zone.HAND, source, game);
            } else {
                Card card;
                TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to put into your hand"));
                if (controller.choose(Outcome.DrawCard, (Cards)cards, target, source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
                    cards.remove(card);
                    controller.moveCards(card, Zone.HAND, source, game);
                }
                controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
            }
        }
        return true;
    }
}

