/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class WorldpurgeEffect
extends OneShotEffect {
    WorldpurgeEffect() {
        super(Outcome.Discard);
        this.staticText = "Return all permanents to their owners' hands. Each player chooses up to seven cards in their hand, then shuffles the rest into their library. Each player loses all unspent mana";
    }

    private WorldpurgeEffect(WorldpurgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public WorldpurgeEffect copy() {
        return new WorldpurgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            HashSet allPermanents = new HashSet();
            allPermanents.addAll(game.getBattlefield().getActivePermanents(new FilterPermanent(), source.getControllerId(), source, game));
            controller.moveCards(allPermanents, Zone.HAND, source, game, false, false, true, null);
            game.informPlayers(sourceObject.getLogName() + " - All permanents returned to owners' hands");
            for (UUID playerId : game.getState().getPlayerList(controller.getId())) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                Cards hand = player.getHand();
                int numberInHand = Math.min(7, hand.size());
                TargetCardInHand target = new TargetCardInHand(0, numberInHand, new FilterCard("cards to keep in hand"));
                CardsImpl cardsToLibrary = new CardsImpl();
                cardsToLibrary.addAll((Collection)player.getHand());
                if (player.choose(Outcome.Benefit, (Target)target, source, game)) {
                    cardsToLibrary.removeAll((Collection)target.getTargets());
                }
                player.shuffleCardsToLibrary((Cards)cardsToLibrary, game, source);
            }
            game.emptyManaPools(source);
            game.informPlayers(sourceObject.getLogName() + " - All players have lost all unspent mana");
            return true;
        }
        return false;
    }
}

