/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WormsOfTheEarthDestroyEffect
extends OneShotEffect {
    WormsOfTheEarthDestroyEffect() {
        super(Outcome.Benefit);
        this.staticText = "any player may sacrifice two lands or have {this} deal 5 damage to that player. If a player does either, destroy {this}";
    }

    private WormsOfTheEarthDestroyEffect(WormsOfTheEarthDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            SacrificeTargetCost cost = new SacrificeTargetCost(2, (FilterPermanent)StaticFilters.FILTER_LANDS);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.chooseUse(this.outcome, "Do you want to destroy " + sourcePermanent.getLogName() + "? (sacrifice two lands or have it deal 5 damage to you)", source, game)) continue;
                cost.clearPaid();
                if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(Outcome.Sacrifice, "Will you sacrifice two lands? (otherwise you'll be dealt 5 damage)", source, game)) {
                    if (!cost.pay(source, game, source, player.getId(), false, null)) {
                        player.damage(5, source.getSourceId(), source, game);
                    }
                } else {
                    player.damage(5, source.getSourceId(), source, game);
                }
                if ((sourcePermanent = game.getPermanent(source.getSourceId())) == null) break;
                sourcePermanent.destroy(source, game, false);
                break;
            }
            return true;
        }
        return false;
    }

    public WormsOfTheEarthDestroyEffect copy() {
        return new WormsOfTheEarthDestroyEffect(this);
    }
}

