/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.GetEnergyCountersControllerEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class WrathOfTheSkiesEffect
extends OneShotEffect {
    WrathOfTheSkiesEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "You get X {E}, then you may pay any amount of {E}. Destroy each artifact, creature, and enchantment with mana value less than or equal to the amount of {E} paid this way.";
    }

    private WrathOfTheSkiesEffect(WrathOfTheSkiesEffect effect) {
        super((OneShotEffect)effect);
    }

    public WrathOfTheSkiesEffect copy() {
        return new WrathOfTheSkiesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int numberToPay;
        PayEnergyCost cost;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xValue > 0) {
            new GetEnergyCountersControllerEffect(xValue).apply(game, source);
        }
        if ((cost = new PayEnergyCost(numberToPay = controller.getAmount(0, controller.getCountersCount(CounterType.ENERGY), "Pay any amount of {E}", source, game))).pay(source, game, source, source.getControllerId(), true)) {
            game.getBattlefield().getActivePermanents(controller.getId(), game).stream().filter(permanent -> permanent.isArtifact(game) || permanent.isCreature(game) || permanent.isEnchantment(game)).filter(permanent -> permanent.getManaValue() <= numberToPay).forEach(permanent -> permanent.destroy(source, game, false));
        }
        return true;
    }
}

