/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.w.WrathfulRedDragonEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterAnyTarget;
import mage.filter.common.FilterPermanentOrPlayer;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetPermanentOrPlayer;

class WrathfulRedDragonTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    private static final FilterPermanentOrPlayer filter = new FilterAnyTarget("any target that isn't a Dragon");

    WrathfulRedDragonTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new WrathfulRedDragonEffect());
        this.addTarget((Target)new TargetPermanentOrPlayer(filter));
    }

    private WrathfulRedDragonTriggeredAbility(WrathfulRedDragonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public WrathfulRedDragonTriggeredAbility copy() {
        return new WrathfulRedDragonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent dragon = game.getPermanent(event.getTargetId());
        int damage = event.getAmount();
        if (dragon == null || damage < 1 || !dragon.isControlledBy(this.getControllerId()) || !dragon.hasSubtype(SubType.DRAGON, game)) {
            return false;
        }
        this.getEffects().setValue("damagedPermanent", (Object)dragon);
        this.getEffects().setValue("damage", (Object)damage);
        return true;
    }

    public String getRule() {
        return "Whenever a Dragon you control is dealt damage, it deals that much damage to any target that isn't a Dragon.";
    }

    static {
        filter.getPermanentFilter().add(Predicates.not((Predicate)SubType.DRAGON.getPredicate()));
    }
}

