/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class WrenchMindEffect
extends OneShotEffect {
    WrenchMindEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player discards two cards unless they discard an artifact card";
    }

    private WrenchMindEffect(WrenchMindEffect effect) {
        super((OneShotEffect)effect);
    }

    public WrenchMindEffect copy() {
        return new WrenchMindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null || targetPlayer.getHand().isEmpty()) {
            return false;
        }
        if (targetPlayer.getHand().count((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, game) < 1 || !targetPlayer.chooseUse(Outcome.Benefit, "Discard an artifact card?", source, game)) {
            return !targetPlayer.discard(2, false, false, source, game).isEmpty();
        }
        TargetDiscard target = new TargetDiscard((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT_AN, targetPlayer.getId());
        targetPlayer.choose(Outcome.Discard, (Target)target, source, game);
        Card card = targetPlayer.getHand().get(target.getFirstTarget(), game);
        if (card != null && targetPlayer.discard(card, false, source, game)) {
            return true;
        }
        return !targetPlayer.discard(2, false, false, source, game).isEmpty();
    }
}

