/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class WuSpyEffect
extends OneShotEffect {
    WuSpyEffect() {
        super(Outcome.Exile);
        this.staticText = "look at the top two cards of target player's library. Put one of them into their graveyard";
    }

    private WuSpyEffect(WuSpyEffect effect) {
        super((OneShotEffect)effect);
    }

    public WuSpyEffect copy() {
        return new WuSpyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && opponent != null) {
            CardsImpl cards = new CardsImpl(opponent.getLibrary().getTopCards(game, 2));
            if (!cards.isEmpty()) {
                TargetCardInLibrary target = new TargetCardInLibrary(new FilterCard("card to put into graveyard"));
                controller.choose(Outcome.Benefit, (Cards)cards, (TargetCard)target, source, game);
                Card card = cards.get(target.getFirstTarget(), game);
                if (card != null) {
                    cards.remove(card);
                    controller.moveCards(card, Zone.GRAVEYARD, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

