/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ManaSpentToCastCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.AbilityWord;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.PhyrexianWurmToken;
import mage.game.permanent.token.Token;

class WurmquakeEffect
extends OneShotEffect {
    WurmquakeEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = AbilityWord.CORRUPTED.formatWord() + "Create an X/X green Phyrexian Wurm creature token with trample and toxic 1, where X is the amount of mana spent to cast this spell. Then for each opponent with three or more poison counters, you create another one of those tokens.";
    }

    private WurmquakeEffect(WurmquakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public WurmquakeEffect copy() {
        return new WurmquakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = ManaSpentToCastCount.instance.calculate(game, source, (Effect)this);
        new CreateTokenEffect((Token)new PhyrexianWurmToken(xValue)).apply(game, source);
        int amount = 0;
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            if (game.getPlayer(opponentId).getCountersCount(CounterType.POISON) < 3) continue;
            ++amount;
        }
        new CreateTokenEffect((Token)new PhyrexianWurmToken(xValue), amount).apply(game, source);
        return true;
    }
}

