/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.RollDieType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.RollDiceEvent;

class WyllBladeOfFrontiersEffect
extends ReplacementEffectImpl {
    WyllBladeOfFrontiersEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if you would roll one or more dice, instead roll that many dice plus one and ignore the lowest roll";
    }

    private WyllBladeOfFrontiersEffect(WyllBladeOfFrontiersEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        RollDiceEvent rdEvent = (RollDiceEvent)event;
        rdEvent.incAmount(1);
        rdEvent.incIgnoreLowestAmount(1);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ROLL_DICE && ((RollDiceEvent)event).getRollDieType() == RollDieType.NUMERICAL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public WyllBladeOfFrontiersEffect copy() {
        return new WyllBladeOfFrontiersEffect(this);
    }
}

