/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.x.XandersPactCastEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class XandersPactExileEffect
extends OneShotEffect {
    XandersPactExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent exiles the top card of their library. You may cast spells from among those cards this turn. If you cast a spell this way, pay life equal to that spell's mana value rather than pay its mana cost";
    }

    private XandersPactExileEffect(XandersPactExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public XandersPactExileEffect copy() {
        return new XandersPactExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Set cards = game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getLibrary).map(library -> library.getFromTop(game)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards(cards, Zone.EXILED, source, game);
        for (Card card : cards) {
            game.addEffect((ContinuousEffect)new XandersPactCastEffect(game, card), source);
        }
        return true;
    }
}

