/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class XantchaSleeperAgentAttackRestrictionEffect
extends RestrictionEffect {
    XantchaSleeperAgentAttackRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "and can't attack its owner or planeswalkers its owner controls.";
    }

    private XantchaSleeperAgentAttackRestrictionEffect(XantchaSleeperAgentAttackRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public XantchaSleeperAgentAttackRestrictionEffect copy() {
        return new XantchaSleeperAgentAttackRestrictionEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return Objects.equals(permanent.getId(), source.getSourceId());
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        Permanent planeswalker;
        if (defenderId == null) {
            return true;
        }
        boolean allowAttack = true;
        UUID ownerPlayerId = source.getSourcePermanentIfItStillExists(game).getOwnerId();
        if (defenderId.equals(ownerPlayerId) && game.getPlayers().size() == 2) {
            allowAttack = false;
        }
        if (defenderId.equals(ownerPlayerId)) {
            allowAttack = false;
        }
        if ((planeswalker = game.getPermanent(defenderId)) != null && planeswalker.isControlledBy(ownerPlayerId)) {
            allowAttack = false;
        }
        return allowAttack;
    }
}

