/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeControllerEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class YawgmothDemonEffect
extends OneShotEffect {
    YawgmothDemonEffect() {
        super(Outcome.Detriment);
        this.staticText = "you may sacrifice an artifact. If you don't, tap {this} and it deals 2 damage to you";
    }

    private YawgmothDemonEffect(YawgmothDemonEffect effect) {
        super((OneShotEffect)effect);
    }

    public YawgmothDemonEffect copy() {
        return new YawgmothDemonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sourceObject;
            int artifacts = game.getBattlefield().countAll((FilterPermanent)new FilterArtifactPermanent(), source.getControllerId(), game);
            boolean artifactSacrificed = false;
            if (artifacts > 0 && controller.chooseUse(this.outcome, "Sacrifice an artifact?", source, game) && new SacrificeControllerEffect((FilterPermanent)new FilterArtifactPermanent(), 1, "").apply(game, source)) {
                artifactSacrificed = true;
            }
            if (!artifactSacrificed && (sourceObject = source.getSourcePermanentIfItStillExists(game)) != null) {
                sourceObject.tap(source, game);
                controller.damage(2, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

