/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class YorvoLordOfGarenbrigEffect
extends OneShotEffect {
    YorvoLordOfGarenbrigEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on {this}. Then if that creature's power is greater than {this}'s power, put another +1/+1 counter on {this}.";
    }

    private YorvoLordOfGarenbrigEffect(YorvoLordOfGarenbrigEffect effect) {
        super((OneShotEffect)effect);
    }

    public YorvoLordOfGarenbrigEffect copy() {
        return new YorvoLordOfGarenbrigEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePerm = game.getPermanent(source.getSourceId());
        if (sourcePerm == null) {
            return false;
        }
        sourcePerm.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent == null) {
            return true;
        }
        game.processAction();
        if (permanent.getPower().getValue() > sourcePerm.getPower().getValue()) {
            sourcePerm.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }
}

