/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Elemental44Token;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.common.TargetOpponent;

class ZaffaiThunderConductorEffect
extends OneShotEffect {
    ZaffaiThunderConductorEffect() {
        super(Outcome.Benefit);
        this.staticText = "scry 1. If that spell's mana value is 5 or greater, create a 4/4 blue and red Elemental creature token. If that spell's mana value is 10 or greater, {this} deals 10 damage to an opponent chosen at random";
    }

    private ZaffaiThunderConductorEffect(ZaffaiThunderConductorEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZaffaiThunderConductorEffect copy() {
        return new ZaffaiThunderConductorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.scry(1, source, game);
        Spell spell = (Spell)this.getValue("castCopiedSpell");
        if (spell == null || spell.getManaValue() < 5) {
            return true;
        }
        new Elemental44Token().putOntoBattlefield(1, game, source, source.getControllerId());
        if (spell.getManaValue() < 10) {
            return true;
        }
        TargetOpponent target = new TargetOpponent(true);
        target.setRandom(true);
        target.chooseTarget(Outcome.Damage, player.getId(), source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (opponent != null) {
            opponent.damage(10, source.getSourceId(), source, game);
        }
        return true;
    }
}

