/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.DomainValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ZarOjanenScionOfEfravaEffect
extends OneShotEffect {
    ZarOjanenScionOfEfravaEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on each creature you control with toughness less than the number of basic land types among lands you control";
    }

    private ZarOjanenScionOfEfravaEffect(ZarOjanenScionOfEfravaEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZarOjanenScionOfEfravaEffect copy() {
        return new ZarOjanenScionOfEfravaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        StringBuilder sb = new StringBuilder();
        if (sourceObject != null) {
            sb.append(sourceObject.getLogName());
            sb.append(": ");
        }
        if (controller != null) {
            sb.append(controller.getLogName());
        } else {
            sb.append("controller");
        }
        sb.append(" puts a +1/+1 counter on ");
        String prefix = sb.toString();
        int basicLandTypes = DomainValue.REGULAR.calculate(game, source, (Effect)this);
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (!permanent.isCreature(game) || permanent.getToughness().getValue() >= basicLandTypes) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
            if (game.isSimulation()) continue;
            game.informPlayers(prefix + permanent.getLogName());
        }
        return true;
    }
}

