/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterPlayerOrPlaneswalker;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetPlayerOrPlaneswalker;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ZaraRenegadeRecruiterEffect
extends OneShotEffect {
    ZaraRenegadeRecruiterEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at defending player's hand. You may put a creature card from it onto the battlefield under your control tapped and attacking that player or a planeswalker they control. Return that creature to its owner's hand at the beginning of the next end step";
    }

    private ZaraRenegadeRecruiterEffect(ZaraRenegadeRecruiterEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZaraRenegadeRecruiterEffect copy() {
        return new ZaraRenegadeRecruiterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID defenderId;
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null || player.getHand().isEmpty()) {
            return false;
        }
        TargetCard targetCard = new TargetCard(0, 1, Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        controller.choose(Outcome.Detriment, player.getHand(), targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card == null) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        if (game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_PLANESWALKER, player.getId(), source, game) < 1) {
            defenderId = player.getId();
        } else {
            FilterPlayerOrPlaneswalker filter = new FilterPlayerOrPlaneswalker(player.getName() + " or a planeswalker controlled by " + player.getName());
            filter.getPlayerFilter().add((Predicate)new PlayerIdPredicate(player.getId()));
            filter.getPermanentFilter().add((Predicate)new ControllerIdPredicate(player.getId()));
            TargetPlayerOrPlaneswalker target = new TargetPlayerOrPlaneswalker(filter);
            target.withNotTarget(true);
            controller.choose(this.outcome, (Target)target, source, game);
            defenderId = target.getFirstTarget();
        }
        game.getCombat().addAttackerToCombat(permanent.getId(), defenderId, game);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ReturnToHandTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(permanent, game))), source);
        return true;
    }
}

