/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ZarethSanTheTricksterEffect
extends OneShotEffect {
    ZarethSanTheTricksterEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put {this} from your hand onto the battlefield tapped and attacking.";
    }

    private ZarethSanTheTricksterEffect(ZarethSanTheTricksterEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZarethSanTheTricksterEffect copy() {
        return new ZarethSanTheTricksterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getHand().get(source.getSourceId(), game);
        if (card == null) {
            return true;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null);
        Permanent permanent = game.getPermanent(card.getId());
        if (permanent != null) {
            game.getCombat().addAttackingCreature(permanent.getId(), game);
        }
        return true;
    }
}

