/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.z.ZaxaraTheExemplaryHydraTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class ZaxaraTheExemplaryHydraTokenAbility
extends TriggeredAbilityImpl {
    public ZaxaraTheExemplaryHydraTokenAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ZaxaraTheExemplaryHydraTokenEffect(), false);
        this.setTriggerPhrase("Whenever you cast a spell with {X} in its mana cost");
    }

    private ZaxaraTheExemplaryHydraTokenAbility(ZaxaraTheExemplaryHydraTokenAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getPlayerId().equals(this.getControllerId()) || event.getType() != GameEvent.EventType.SPELL_CAST) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null || !spell.getSpellAbility().getManaCostsToPay().containsX()) {
            return false;
        }
        game.getState().setValue(this.getSourceId() + "_ZaxaraTheExemplary_NeedToken", (Object)spell);
        return true;
    }

    public ZaxaraTheExemplaryHydraTokenAbility copy() {
        return new ZaxaraTheExemplaryHydraTokenAbility(this);
    }
}

