/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ZaxaraTheExemplaryHydraToken;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class ZaxaraTheExemplaryHydraTokenEffect
extends OneShotEffect {
    ZaxaraTheExemplaryHydraTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = ", create a 0/0 green Hydra creature token, then put X +1/+1 counters on it.";
    }

    private ZaxaraTheExemplaryHydraTokenEffect(ZaxaraTheExemplaryHydraTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZaxaraTheExemplaryHydraTokenEffect copy() {
        return new ZaxaraTheExemplaryHydraTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object needObject;
        Player player = game.getPlayer(source.getControllerId());
        Player controller = game.getPlayer(source.getControllerId());
        if (player != null && controller != null && (needObject = game.getState().getValue(source.getSourceId() + "_ZaxaraTheExemplary_NeedToken")) instanceof Spell) {
            Spell spell = (Spell)needObject;
            int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)spell.getSpellAbility(), (String)"X", (Object)0);
            ZaxaraTheExemplaryHydraToken hydraToken = new ZaxaraTheExemplaryHydraToken();
            hydraToken.putOntoBattlefield(1, game, source, source.getControllerId());
            for (UUID tokenId : hydraToken.getLastAddedTokenIds()) {
                Permanent permanent = game.getPermanent(tokenId);
                if (permanent == null) continue;
                permanent.addCounters(CounterType.P1P1.createInstance(xValue), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }
}

