/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.Iterator;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.z.ZenithChroniclerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.SpellsCastWatcher;

class ZenithChroniclerTriggeredAbility
extends TriggeredAbilityImpl {
    public ZenithChroniclerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ZenithChroniclerEffect());
    }

    private ZenithChroniclerTriggeredAbility(ZenithChroniclerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ZenithChroniclerTriggeredAbility copy() {
        return new ZenithChroniclerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player controller = game.getPlayer(this.getControllerId());
        Spell spell = game.getSpell(event.getTargetId());
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        if (controller != null && spell != null && watcher != null && spell.getColor(game).isMulticolored()) {
            Spell spellCastThisTurn;
            int multicoloredSpell = 0;
            Iterator iterator = watcher.getSpellsCastThisTurn(spell.getControllerId()).iterator();
            while (iterator.hasNext() && (!(spellCastThisTurn = (Spell)iterator.next()).getColor(game).isMulticolored() || ++multicoloredSpell <= 1)) {
            }
            if (multicoloredSpell == 1) {
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer((TargetPointer)new FixedTarget(spell.getControllerId()));
                }
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever a player casts their first multicolored spell each turn, each other player draws a card.";
    }
}

