/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ZephyrSentinelEffect
extends OneShotEffect {
    ZephyrSentinelEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "return up to one other target creature you control to its owner's hand. If it was a Soldier, put a +1/+1 counter on {this}";
    }

    private ZephyrSentinelEffect(ZephyrSentinelEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZephyrSentinelEffect copy() {
        return new ZephyrSentinelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetPermanent == null) {
            return false;
        }
        boolean soldier = targetPermanent.hasSubtype(SubType.SOLDIER, game);
        controller.moveCards((Card)targetPermanent, Zone.HAND, source, game);
        if (soldier) {
            Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(), source, game));
        }
        return true;
    }
}

