/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.ArrayList;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureCard;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class ZeroPointBalladEffect
extends OneShotEffect {
    ZeroPointBalladEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures with toughness X or less. You lose X life. If X is 6 or more, return a creature card put into a graveyard this way to the battlefield under your control.";
    }

    private ZeroPointBalladEffect(ZeroPointBalladEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZeroPointBalladEffect copy() {
        return new ZeroPointBalladEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int xValue = GetXValue.instance.calculate(game, source, (Effect)this);
        CardsImpl putIntoGraveyardThisWay = new CardsImpl();
        FilterCreaturePermanent filterToDestroy = new FilterCreaturePermanent();
        filterToDestroy.add((Predicate)new ToughnessPredicate(ComparisonType.OR_LESS, xValue));
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filterToDestroy, controller.getId(), source, game)) {
            permanent.destroy(source, game, false);
            if (game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD) continue;
            putIntoGraveyardThisWay.add((Card)permanent);
        }
        game.processAction();
        new LoseLifeSourceControllerEffect(xValue).apply(game, source);
        if (xValue < 6) {
            return true;
        }
        game.processAction();
        MageObject sourceObject = game.getObject(source);
        String sourceName = sourceObject != null ? sourceObject.getLogName() : "";
        FilterCreatureCard filter = new FilterCreatureCard("creature card put into a graveyard with " + sourceName);
        ArrayList<CardIdPredicate> cardIdPredicates = new ArrayList<CardIdPredicate>();
        for (UUID cardId : putIntoGraveyardThisWay) {
            cardIdPredicates.add(new CardIdPredicate(cardId));
        }
        filter.add(Predicates.or(cardIdPredicates));
        TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)filter);
        target.withNotTarget(true);
        if (!controller.chooseTarget(Outcome.PutCreatureInPlay, (Target)target, source, game)) {
            return true;
        }
        Card cardToReturn = game.getCard(target.getFirstTarget());
        if (cardToReturn == null) {
            return true;
        }
        controller.moveCards(cardToReturn, Zone.BATTLEFIELD, source, game);
        return true;
    }
}

