/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class ZimoneAndDinaEffect
extends OneShotEffect {
    ZimoneAndDinaEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card. You may put a land card from your hand onto the battlefield tapped. If you control eight or more lands, repeat this process once";
    }

    private ZimoneAndDinaEffect(ZimoneAndDinaEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZimoneAndDinaEffect copy() {
        return new ZimoneAndDinaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        this.drawAndPlayLand(player, source, game);
        if (game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source.getControllerId(), source, game) >= 8) {
            this.drawAndPlayLand(player, source, game);
        }
        return true;
    }

    private void drawAndPlayLand(Player player, Ability source, Game game) {
        player.drawCards(1, source, game);
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND_A);
        player.choose(Outcome.PutCardInPlay, (Target)target, source, game);
        player.moveCards(game.getCard(target.getFirstTarget()), Zone.BATTLEFIELD, source, game, true, false, false, null);
    }
}

