/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ZirilanOfTheClawEffect
extends OneShotEffect {
    ZirilanOfTheClawEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Search your library for a Dragon permanent card, put that card onto the battlefield, then shuffle. That Dragon gains haste until end of turn. Exile it at the beginning of the next end step";
    }

    private ZirilanOfTheClawEffect(ZirilanOfTheClawEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZirilanOfTheClawEffect copy() {
        return new ZirilanOfTheClawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            FilterPermanentCard filter = new FilterPermanentCard("a Dragon permanent card");
            filter.add((Predicate)SubType.DRAGON.getPredicate());
            TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)filter);
            if (controller.searchLibrary(target, source, game)) {
                Card card = controller.getLibrary().getCard(target.getFirstTarget(), game);
                if (card != null) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                    Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
                    if (permanent != null) {
                        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
                        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                        game.addEffect((ContinuousEffect)effect, source);
                        ExileTargetEffect exileEffect = new ExileTargetEffect(null, null, Zone.BATTLEFIELD);
                        exileEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                        AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect);
                        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

