/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.z.ZombieBoaTriggeredAbility;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ZombieBoaEffect
extends OneShotEffect {
    ZombieBoaEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a color. Whenever {this} becomes blocked by a creature of that color this turn, destroy that creature";
    }

    private ZombieBoaEffect(ZombieBoaEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZombieBoaEffect copy() {
        return new ZombieBoaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ChoiceColor choice = new ChoiceColor();
        if (player.choose(this.outcome, (Choice)choice, game)) {
            ObjectColor color = choice.getColor();
            game.informPlayers(player.getLogName() + " chooses " + color);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new ZombieBoaTriggeredAbility(color), source);
            return true;
        }
        return false;
    }
}

