/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.OrCost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class ZoyowaLavaTongueEffect
extends OneShotEffect {
    ZoyowaLavaTongueEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent may discard a card or sacrifice a permanent. {this} deals 3 damage to each opponent who didn't";
    }

    private ZoyowaLavaTongueEffect(ZoyowaLavaTongueEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZoyowaLavaTongueEffect copy() {
        return new ZoyowaLavaTongueEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Set opponentsIds = game.getOpponents(source.getControllerId());
        ArrayList<Player> opponentThatDidNotPay = new ArrayList<Player>();
        for (UUID id : game.getState().getPlayerList(source.getControllerId())) {
            boolean choseToPay;
            Player opponent;
            if (!opponentsIds.contains(id) || (opponent = game.getPlayer(id)) == null) continue;
            OrCost cost = new OrCost("discard a card or sacrifice a permanent?", new Cost[]{new DiscardCardCost(), new SacrificeTargetCost(StaticFilters.FILTER_PERMANENT)});
            boolean bl = choseToPay = cost.canPay(source, source, id, game) && opponent.chooseUse(Outcome.Neutral, "Do you wish to discard a card or sacrifice a permanent to avoid 3 damage to you?", source, game);
            if (choseToPay && cost.pay(source, game, source, id, false)) continue;
            opponentThatDidNotPay.add(opponent);
        }
        for (Player opponent : opponentThatDidNotPay) {
            opponent.damage(3, source.getSourceId(), source, game);
        }
        return true;
    }
}

