/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ZurgoAndOjutaiEffect
extends OneShotEffect {
    ZurgoAndOjutaiEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may return one of those Dragons to its owner's hand";
    }

    private ZurgoAndOjutaiEffect(ZurgoAndOjutaiEffect effect) {
        super((OneShotEffect)effect);
    }

    public ZurgoAndOjutaiEffect copy() {
        return new ZurgoAndOjutaiEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List predicates = this.getTargetPointer().getTargets(game, source).stream().map(PermanentIdPredicate::new).collect(Collectors.toList());
        if (predicates.isEmpty()) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent("Dragon");
        filter.add(Predicates.or(predicates));
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        target.withChooseHint("return to hand");
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && player.moveCards((Card)permanent, Zone.HAND, source, game);
    }
}

