/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class ZursWeirdingReplacementEffect
extends ReplacementEffectImpl {
    ZursWeirdingReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If a player would draw a card, they reveal it instead. Then any other player may pay 2 life. If a player does, put that card into its owner's graveyard. Otherwise, that player draws a card.";
    }

    private ZursWeirdingReplacementEffect(ZursWeirdingReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ZursWeirdingReplacementEffect copy() {
        return new ZursWeirdingReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        boolean paid = false;
        Player player = game.getPlayer(event.getTargetId());
        MageObject sourceObject = source.getSourceObject(game);
        if (player == null || sourceObject == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(sourceObject.getIdName() + " next draw of " + player.getName() + " (" + game.getTurnNum() + '|' + game.getTurnPhaseType() + ')', (Cards)new CardsImpl(card), game);
        String message = "Pay 2 life to put " + card.getLogName() + " into " + player.getLogName() + " graveyard?";
        for (UUID playerId : game.getState().getPlayersInRange(player.getId(), game)) {
            Player otherPlayer;
            if (playerId.equals(player.getId()) || (otherPlayer = game.getPlayer(playerId)) == null || !otherPlayer.canPayLifeCost(source) || otherPlayer.getLife() < 2) continue;
            PayLifeCost lifeCost = new PayLifeCost(2);
            if (!otherPlayer.chooseUse(Outcome.Benefit, message, source, game) || !lifeCost.pay(source, game, source, otherPlayer.getId(), true)) continue;
            player.moveCards(card, Zone.GRAVEYARD, source, game);
            return true;
        }
        player.drawCards(1, source, game, event);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }
}

