/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import mage.MageItem;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.z.ZurzothChaosRiderEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.combat.Combat;
import mage.game.events.GameEvent;

class ZurzothChaosRiderAttackAbility
extends TriggeredAbilityImpl {
    ZurzothChaosRiderAttackAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private ZurzothChaosRiderAttackAbility(ZurzothChaosRiderAttackAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        HashSet<UUID> playerIds = new HashSet<UUID>();
        game.getCombat().getAttackers().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.isControlledBy(this.getControllerId())).filter(permanent -> permanent.hasSubtype(SubType.DEVIL, game)).map(MageItem::getId).map(arg_0 -> ((Combat)game.getCombat()).getDefenderId(arg_0)).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(MageItem::getId).forEach(playerIds::add);
        if (playerIds.isEmpty()) {
            return false;
        }
        playerIds.add(this.getControllerId());
        this.getEffects().clear();
        this.addEffect((Effect)new ZurzothChaosRiderEffect(playerIds));
        return true;
    }

    public ZurzothChaosRiderAttackAbility copy() {
        return new ZurzothChaosRiderAttackAbility(this);
    }

    public String getRule() {
        return "Whenever one or more Devils you control attack one or more players, you and those players each draw a card, then discard a card at random.";
    }
}

