/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.DevilToken;
import mage.game.permanent.token.Token;

class ZurzothChaosRiderDrawAbility
extends TriggeredAbilityImpl {
    private final Set<UUID> playerIds = new HashSet<UUID>();

    ZurzothChaosRiderDrawAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new DevilToken()));
    }

    private ZurzothChaosRiderDrawAbility(ZurzothChaosRiderDrawAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.playerIds.addAll(ability.playerIds);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD || event.getType() == GameEvent.EventType.END_PHASE_POST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        switch (event.getType()) {
            case END_PHASE_POST: {
                this.playerIds.clear();
                return false;
            }
            case DREW_CARD: {
                if (this.playerIds.contains(event.getPlayerId())) {
                    return false;
                }
                this.playerIds.add(event.getPlayerId());
                return !game.isActivePlayer(event.getPlayerId()) && game.getOpponents(this.getControllerId()).contains(event.getPlayerId());
            }
        }
        return false;
    }

    public ZurzothChaosRiderDrawAbility copy() {
        return new ZurzothChaosRiderDrawAbility(this);
    }

    public String getRule() {
        return "Whenever an opponent draws their first card each turn, if it's not their turn, you create a 1/1 red Devil creature token with \"When this creature dies, it deals 1 damage to any target.\"";
    }
}

