/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.encryption;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.jboss.logging.Logger;

public class EncryptionManager {
    private static Logger log;
    private static Map keys;
    private static byte[] salt8;
    private static byte[] salt16;
    private static IvParameterSpec iv8;
    private static IvParameterSpec iv16;
    public static final String TRIPLEDES = "DESede";
    public static final String DES = "DES";
    public static final String AES = "AES";
    public static final String BLOWFISH = "Blowfish";
    public static final String RC4 = "RC4";
    public static final String DEFAULT_CIPHER_ALGORITHM = "DES";

    public static Cipher getCipher(int mode, String algo) {
        boolean correctMode;
        if (algo == null) {
            algo = "DES";
        }
        Cipher cipher = null;
        boolean bl = correctMode = mode == 1 || mode == 2;
        if (!correctMode) {
            throw new IllegalArgumentException("Cipher Mode is wrong");
        }
        try {
            cipher = Cipher.getInstance(algo);
            Key key = (Key)keys.get(EncryptionManager.canonicalize(algo));
            if (key == null) {
                throw new IllegalStateException("Key is null for algo=" + algo);
            }
            EncryptionManager.initializeCipher(cipher, key, algo, mode);
        }
        catch (Throwable e) {
            log.error((Object)"getCipher failed", e);
        }
        return cipher;
    }

    public static Cipher getCipher(int mode, String algo, Key key) {
        Cipher cipher;
        block3: {
            boolean correctMode;
            cipher = null;
            boolean bl = correctMode = mode == 1 || mode == 2;
            if (!correctMode) {
                throw new IllegalArgumentException("Cipher Mode is wrong");
            }
            try {
                cipher = Cipher.getInstance(algo);
                EncryptionManager.initializeCipher(cipher, key, algo, mode);
            }
            catch (Throwable e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace((Object)"getCipher failed:", e);
            }
        }
        return cipher;
    }

    private static Key loadKey(String algo) throws Exception {
        String file;
        ClassLoader tcl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        InputStream is = tcl.getResourceAsStream(file = "org/jboss/remoting/marshall/encryption/" + algo + ".key");
        if (is == null) {
            throw new IllegalStateException("Key file is not locatable");
        }
        ObjectInputStream out = new ObjectInputStream(is);
        Key key = (Key)out.readObject();
        out.close();
        return key;
    }

    private static String canonicalize(String algo) {
        if (algo == null) {
            throw new IllegalArgumentException("Null algorithm passed");
        }
        String result = algo;
        if (algo.indexOf("/") > 0) {
            result = algo.substring(0, algo.indexOf("/"));
        }
        return result;
    }

    private static void initializeCipher(Cipher cipher, Key key, String algo, int mode) throws Exception {
        if (algo.equals(AES) || algo.equals("DES") || algo.equals(TRIPLEDES) || algo.equals(RC4) || algo.equals(BLOWFISH)) {
            cipher.init(mode, key);
        } else if (algo.indexOf(AES) == 0 && algo.indexOf("AES/ECB") < 0) {
            cipher.init(mode, key, iv16);
        } else if (algo.indexOf("/CBC/") > 0 || algo.indexOf("/OFB/") > 0 || algo.indexOf("/PCBC/") > 0 || algo.indexOf("/CFB/") > 0) {
            cipher.init(mode, key, iv8);
        } else {
            cipher.init(mode, key);
        }
    }

    static {
        block2: {
            log = Logger.getLogger((Class)EncryptionManager.class);
            keys = new ConcurrentHashMap();
            salt8 = new byte[]{126, -18, -56, -57, -103, 115, 33, -116};
            salt16 = new byte[]{126, -18, -56, -57, -103, 115, 33, -116, 126, -18, -56, -57, -103, 115, 33, -116};
            iv8 = new IvParameterSpec(salt8);
            iv16 = new IvParameterSpec(salt16);
            try {
                keys.put(AES, EncryptionManager.loadKey(AES));
                keys.put("DES", EncryptionManager.loadKey("DES"));
                keys.put(TRIPLEDES, EncryptionManager.loadKey(TRIPLEDES));
                keys.put(BLOWFISH, EncryptionManager.loadKey(BLOWFISH));
                keys.put(RC4, EncryptionManager.loadKey(RC4));
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Exception in loading key", (Throwable)e);
            }
        }
    }
}

