/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.ConditionalMana;
import mage.MageItem;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.SpecialAction;
import mage.abilities.SpellAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ColoredManaCost;
import mage.abilities.costs.mana.ColorlessHybridManaCost;
import mage.abilities.costs.mana.ColorlessManaCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.HybridManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.MonoHybridManaCost;
import mage.abilities.costs.mana.SnowManaCost;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.abilities.mana.ManaOptions;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.RateCard;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidator;
import mage.cards.decks.DeckValidatorFactory;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.choices.Choice;
import mage.constants.AsThoughEffectType;
import mage.constants.CardType;
import mage.constants.ColoredManaSymbol;
import mage.constants.ManaType;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.constants.RangeOfInfluence;
import mage.constants.Rarity;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.game.draft.Draft;
import mage.game.match.Match;
import mage.game.permanent.Permanent;
import mage.game.tournament.Tournament;
import mage.player.ai.PossibleTargetsComparator;
import mage.player.ai.PossibleTargetsSelector;
import mage.players.ManaPoolItem;
import mage.players.Player;
import mage.players.PlayerImpl;
import mage.players.net.UserData;
import mage.players.net.UserGroup;
import mage.target.Target;
import mage.target.TargetAmount;
import mage.target.TargetCard;
import mage.util.CardUtil;
import mage.util.ManaUtil;
import mage.util.MultiAmountMessage;
import mage.util.RandomUtil;
import mage.util.TournamentUtil;
import org.apache.log4j.Logger;

public class ComputerPlayer
extends PlayerImpl {
    private static final Logger logger = Logger.getLogger(ComputerPlayer.class);
    protected static final int PASSIVITY_PENALTY = 5;
    public static final boolean COMPUTER_DISABLE_TIMEOUT_IN_GAME_SIMULATIONS = false;
    static final int COMPUTER_MAX_THREADS_FOR_SIMULATIONS = 5;
    private final transient List<PickedCard> pickedCards = new ArrayList<PickedCard>();
    private final transient List<ColoredManaSymbol> chosenColors = new ArrayList<ColoredManaSymbol>();
    private final transient Map<UUID, ManaCost> lastUnpaidMana = new LinkedHashMap<UUID, ManaCost>();
    private transient boolean alreadyTryingToPayPhyrexian;

    public ComputerPlayer(String name, RangeOfInfluence range) {
        super(name, range);
        this.human = false;
        this.userData = UserData.getDefaultUserDataView();
        this.userData.setAvatarId(64);
        this.userData.setGroupId(UserGroup.COMPUTER.getGroupId());
        this.userData.setFlagName("computer.png");
    }

    protected ComputerPlayer(UUID id) {
        super(id);
        this.human = false;
        this.userData = UserData.getDefaultUserDataView();
        this.userData.setAvatarId(64);
        this.userData.setGroupId(UserGroup.COMPUTER.getGroupId());
        this.userData.setFlagName("computer.png");
    }

    public ComputerPlayer(ComputerPlayer player) {
        super((PlayerImpl)player);
    }

    public boolean chooseMulligan(Game game) {
        if (this.hand.size() < 6 || this.isTestMode() || game.getClass().getName().contains("Momir")) {
            return false;
        }
        Set lands = this.hand.getCards((FilterCard)new FilterLandCard(), game);
        return lands.size() < 2 || lands.size() > this.hand.size() - 2;
    }

    public boolean choose(Outcome outcome, Target target, Ability source, Game game) {
        return this.choose(outcome, target, source, game, null);
    }

    public boolean choose(Outcome outcome, Target target, Ability source, Game game, Map<String, Serializable> options) {
        return this.makeChoice(outcome, target, source, game, null);
    }

    private boolean makeChoice(Outcome outcome, Target target, Ability source, Game game, Cards fromCards) {
        if (target.getMessage(game).equals("Select a starting player")) {
            target.add(this.getId(), game);
            return true;
        }
        if (fromCards != null && fromCards.isEmpty()) {
            return false;
        }
        UUID abilityControllerId = target.getAffectedAbilityControllerId(this.getId());
        if (target.isChoiceCompleted(abilityControllerId, source, game, fromCards)) {
            return false;
        }
        PossibleTargetsSelector possibleTargetsSelector = new PossibleTargetsSelector(outcome, target, abilityControllerId, source, game);
        possibleTargetsSelector.findNewTargets((Set<UUID>)fromCards);
        if (!possibleTargetsSelector.hasAnyTargets()) {
            return false;
        }
        if (!possibleTargetsSelector.hasMinNumberOfTargets()) {
            return false;
        }
        for (MageItem item : possibleTargetsSelector.getGoodTargets()) {
            target.add(item.getId(), game);
            if (!target.isChoiceCompleted(abilityControllerId, source, game, fromCards)) continue;
            return true;
        }
        for (MageItem item : possibleTargetsSelector.getBadTargets()) {
            if (target.isChosen(game)) break;
            target.add(item.getId(), game);
        }
        return target.isChosen(game) && !target.getTargets().isEmpty();
    }

    private int makeChoiceAmount(int min, int max, Game game, Ability source, boolean isManaPay) {
        int xValue;
        if (min >= max) {
            return min;
        }
        int realMin = min;
        int realMax = max;
        if (max == Integer.MAX_VALUE) {
            realMax = Math.max(realMin, 10);
        }
        if ((xValue = isManaPay ? Math.max(0, this.getAvailableManaProducers(game).size() - source.getManaCostsToPay().getUnpaid().manaValue()) : RandomUtil.nextInt((int)(realMax + 1))) > realMax) {
            xValue = realMax;
        }
        if (xValue < realMin) {
            xValue = realMin;
        }
        return xValue;
    }

    public boolean chooseTarget(Outcome outcome, Target target, Ability source, Game game) {
        return this.makeChoice(outcome, target, source, game, null);
    }

    public boolean chooseTargetAmount(Outcome outcome, TargetAmount target, Ability source, Game game) {
        target.prepareAmount(source, game);
        if (target.getAmountRemaining() <= 0) {
            return false;
        }
        if (target.getMaxNumberOfTargets() == 0 && target.getMinNumberOfTargets() == 0) {
            return false;
        }
        UUID abilityControllerId = target.getAffectedAbilityControllerId(this.getId());
        if (target.isChoiceCompleted(abilityControllerId, source, game, null)) {
            return false;
        }
        PossibleTargetsSelector possibleTargetsSelector = new PossibleTargetsSelector(outcome, (Target)target, abilityControllerId, source, game);
        possibleTargetsSelector.findNewTargets(null);
        if (!possibleTargetsSelector.hasAnyTargets()) {
            return false;
        }
        if (!possibleTargetsSelector.hasMinNumberOfTargets()) {
            return false;
        }
        if (outcome == Outcome.Damage) {
            int leftLife;
            for (MageItem item : possibleTargetsSelector.getGoodTargets()) {
                if (target.getAmountRemaining() <= 0) break;
                if (target.contains(item.getId()) || !(item instanceof Player) || (leftLife = PossibleTargetsComparator.getLifeForDamage(item, game)) <= 0 || leftLife > target.getAmountRemaining()) continue;
                target.addTarget(item.getId(), leftLife, source, game);
                if (!target.isChoiceCompleted(abilityControllerId, source, game, null)) continue;
                return true;
            }
            for (MageItem item : possibleTargetsSelector.getGoodTargets()) {
                if (target.getAmountRemaining() <= 0) break;
                if (target.contains(item.getId()) || item instanceof Player || (leftLife = PossibleTargetsComparator.getLifeForDamage(item, game)) <= 0 || leftLife > target.getAmountRemaining()) continue;
                target.addTarget(item.getId(), leftLife, source, game);
                if (!target.isChoiceCompleted(abilityControllerId, source, game, null)) continue;
                return true;
            }
            for (MageItem item : possibleTargetsSelector.getGoodTargets()) {
                if (target.getAmountRemaining() <= 0) break;
                if (target.contains(item.getId())) continue;
                target.addTarget(item.getId(), target.getAmountRemaining(), source, game);
                if (!target.isChoiceCompleted(abilityControllerId, source, game, null)) continue;
                return true;
            }
            for (MageItem item : possibleTargetsSelector.getBadTargets()) {
                if (target.getAmountRemaining() <= 0) break;
                if (target.contains(item.getId())) continue;
                if (target.isChosen(game)) {
                    return !target.getTargets().isEmpty();
                }
                leftLife = PossibleTargetsComparator.getLifeForDamage(item, game);
                if (leftLife <= 1) continue;
                target.addTarget(item.getId(), Math.min(leftLife - 1, target.getAmountRemaining()), source, game);
                if (!target.isChoiceCompleted(abilityControllerId, source, game, null)) continue;
                return true;
            }
            for (MageItem item : possibleTargetsSelector.getBadTargets()) {
                if (target.getAmountRemaining() <= 0) break;
                if (target.contains(item.getId())) continue;
                if (target.isChosen(game)) {
                    return !target.getTargets().isEmpty();
                }
                target.addTarget(item.getId(), target.getAmountRemaining(), source, game);
                if (!target.isChoiceCompleted(abilityControllerId, source, game, null)) continue;
                return true;
            }
            return target.isChosen(game);
        }
        for (MageItem item : possibleTargetsSelector.getGoodTargets()) {
            if (target.getAmountRemaining() <= 0) break;
            if (target.contains(item.getId())) continue;
            target.addTarget(item.getId(), target.getAmountRemaining(), source, game);
            if (!target.isChoiceCompleted(abilityControllerId, source, game, null)) continue;
            return true;
        }
        for (MageItem item : possibleTargetsSelector.getBadTargets()) {
            if (target.getAmountRemaining() <= 0) break;
            if (target.contains(item.getId())) continue;
            if (target.isChosen(game)) {
                return !target.getTargets().isEmpty();
            }
            target.addTarget(item.getId(), target.getAmountRemaining(), source, game);
            if (!target.isChoiceCompleted(abilityControllerId, source, game, null)) continue;
            return true;
        }
        return target.isChosen(game) && !target.getTargets().isEmpty();
    }

    public boolean priority(Game game) {
        this.pass(game);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playMana(Ability ability, ManaCost unpaid, String promptText, Game game) {
        this.payManaMode = true;
        this.lastUnpaidMana.put(ability.getId(), unpaid.copy());
        try {
            boolean bl = this.playManaHandling(ability, unpaid, game);
            return bl;
        }
        finally {
            this.lastUnpaidMana.remove(ability.getId());
            this.payManaMode = false;
        }
    }

    protected boolean playManaHandling(Ability ability, ManaCost unpaid, Game game) {
        ManaOptions specialMana;
        List<MageObject> producers;
        ManaCost cost;
        boolean hasApprovingObject;
        Set approvingObjects = game.getContinuousEffects().asThough(ability.getSourceId(), AsThoughEffectType.SPEND_OTHER_MANA, ability, ability.getControllerId(), game);
        boolean bl = hasApprovingObject = !approvingObjects.isEmpty();
        if (unpaid instanceof ManaCosts) {
            ManaCosts manaCosts = (ManaCosts)unpaid;
            cost = (ManaCost)manaCosts.get(manaCosts.size() - 1);
            producers = this.getSortedProducers((ManaCosts<ManaCost>)((ManaCosts)unpaid), game);
        } else {
            cost = unpaid;
            producers = this.getAvailableManaProducers(game);
            producers.addAll(this.getAvailableManaProducersWithCost(game));
        }
        for (MageObject mageObject : producers) {
            block1: for (ActivatedManaAbilityImpl manaAbility : this.getManaAbilitiesSortedByManaCount(mageObject, game)) {
                boolean canPayColoredMana = false;
                for (Mana mana : manaAbility.getNetMana(game)) {
                    if (!unpaid.getMana().includesMana(mana)) continue block1;
                    if (mana.getAny() > 0) {
                        throw new IllegalArgumentException("Wrong mana calculation: AI do not support color choosing from {Any}");
                    }
                    if (mana.countColored() <= 0) continue;
                    canPayColoredMana = true;
                }
                if (!canPayColoredMana || !(cost instanceof ColoredManaCost)) continue;
                for (Mana netMana : manaAbility.getNetMana(game)) {
                    if (!cost.testPay(netMana) || netMana instanceof ConditionalMana && !((ConditionalMana)netMana).apply(ability, game, this.getId(), (Cost)cost) || hasApprovingObject && !this.canUseAsThoughManaToPayManaCost(cost, ability, netMana, (Ability)manaAbility, mageObject, game) || !this.activateAbility((ActivatedAbility)manaAbility, game)) continue;
                    return true;
                }
            }
        }
        for (MageObject mageObject : producers) {
            for (ActivatedManaAbilityImpl manaAbility : this.getManaAbilitiesSortedByManaCount(mageObject, game)) {
                if (!(cost instanceof ColoredManaCost)) continue;
                for (Mana netMana : manaAbility.getNetMana(game)) {
                    if (!cost.testPay(netMana) && !hasApprovingObject || netMana instanceof ConditionalMana && !((ConditionalMana)netMana).apply(ability, game, this.getId(), (Cost)cost) || hasApprovingObject && !this.canUseAsThoughManaToPayManaCost(cost, ability, netMana, (Ability)manaAbility, mageObject, game) || !this.activateAbility((ActivatedAbility)manaAbility, game)) continue;
                    return true;
                }
            }
            for (ActivatedManaAbilityImpl manaAbility : this.getManaAbilitiesSortedByManaCount(mageObject, game)) {
                if (!(cost instanceof SnowManaCost)) continue;
                for (Mana netMana : manaAbility.getNetMana(game)) {
                    if (!cost.testPay(netMana) && !hasApprovingObject || netMana instanceof ConditionalMana && !((ConditionalMana)netMana).apply(ability, game, this.getId(), (Cost)cost) || hasApprovingObject && !this.canUseAsThoughManaToPayManaCost(cost, ability, netMana, (Ability)manaAbility, mageObject, game) || !this.activateAbility((ActivatedAbility)manaAbility, game)) continue;
                    return true;
                }
            }
            for (ActivatedManaAbilityImpl manaAbility : this.getManaAbilitiesSortedByManaCount(mageObject, game)) {
                if (!(cost instanceof ColorlessManaCost)) continue;
                for (Mana netMana : manaAbility.getNetMana(game)) {
                    if (!cost.testPay(netMana) && !hasApprovingObject || netMana instanceof ConditionalMana && !((ConditionalMana)netMana).apply(ability, game, this.getId(), (Cost)cost) || hasApprovingObject && !this.canUseAsThoughManaToPayManaCost(cost, ability, netMana, (Ability)manaAbility, mageObject, game) || !this.activateAbility((ActivatedAbility)manaAbility, game)) continue;
                    return true;
                }
            }
            for (ActivatedManaAbilityImpl manaAbility : this.getManaAbilitiesSortedByManaCount(mageObject, game)) {
                if (!(cost instanceof HybridManaCost)) continue;
                for (Mana netMana : manaAbility.getNetMana(game)) {
                    if (!cost.testPay(netMana) && !hasApprovingObject || netMana instanceof ConditionalMana && !((ConditionalMana)netMana).apply(ability, game, this.getId(), (Cost)cost) || hasApprovingObject && !this.canUseAsThoughManaToPayManaCost(cost, ability, netMana, (Ability)manaAbility, mageObject, game) || !this.activateAbility((ActivatedAbility)manaAbility, game)) continue;
                    return true;
                }
            }
            for (ActivatedManaAbilityImpl manaAbility : this.getManaAbilitiesSortedByManaCount(mageObject, game)) {
                if (!(cost instanceof ColorlessHybridManaCost)) continue;
                for (Mana netMana : manaAbility.getNetMana(game)) {
                    if (!cost.testPay(netMana) && !hasApprovingObject || netMana instanceof ConditionalMana && !((ConditionalMana)netMana).apply(ability, game, this.getId(), (Cost)cost) || hasApprovingObject && !this.canUseAsThoughManaToPayManaCost(cost, ability, netMana, (Ability)manaAbility, mageObject, game) || !this.activateAbility((ActivatedAbility)manaAbility, game)) continue;
                    return true;
                }
            }
            for (ActivatedManaAbilityImpl manaAbility : this.getManaAbilitiesSortedByManaCount(mageObject, game)) {
                if (!(cost instanceof MonoHybridManaCost)) continue;
                for (Mana netMana : manaAbility.getNetMana(game)) {
                    if (!cost.testPay(netMana) && !hasApprovingObject || netMana instanceof ConditionalMana && !((ConditionalMana)netMana).apply(ability, game, this.getId(), (Cost)cost) || hasApprovingObject && !this.canUseAsThoughManaToPayManaCost(cost, ability, netMana, (Ability)manaAbility, mageObject, game) || !this.activateAbility((ActivatedAbility)manaAbility, game)) continue;
                    return true;
                }
            }
            for (ActivatedManaAbilityImpl manaAbility : this.getManaAbilitiesSortedByManaCount(mageObject, game)) {
                if (!(cost instanceof GenericManaCost)) continue;
                for (Mana netMana : manaAbility.getNetMana(game)) {
                    if (!cost.testPay(netMana) && !hasApprovingObject || netMana instanceof ConditionalMana && !((ConditionalMana)netMana).apply(ability, game, this.getId(), (Cost)cost) || hasApprovingObject && !this.canUseAsThoughManaToPayManaCost(cost, ability, netMana, (Ability)manaAbility, mageObject, game) || !this.activateAbility((ActivatedAbility)manaAbility, game)) continue;
                    return true;
                }
            }
        }
        if (this.alreadyTryingToPayPhyrexian) {
            return false;
        }
        if (cost.isPhyrexian()) {
            this.alreadyTryingToPayPhyrexian = true;
            boolean paidPhyrexian = cost.pay(ability, game, ability, this.playerId, false, null) || hasApprovingObject;
            this.alreadyTryingToPayPhyrexian = false;
            return paidPhyrexian;
        }
        SpecialAction specialAction = game.getState().getSpecialActions().getControlledBy(this.getId(), true).values().stream().findFirst().orElse(null);
        ManaOptions manaOptions = specialMana = specialAction == null ? null : specialAction.getManaOptions(ability, game, unpaid);
        if (specialMana != null) {
            for (Mana netMana : specialMana) {
                if (!cost.testPay(netMana) && !hasApprovingObject || netMana instanceof ConditionalMana && !((ConditionalMana)netMana).apply(ability, game, this.getId(), (Cost)cost)) continue;
                if (!this.activateAbility((ActivatedAbility)specialAction, game)) break;
                return true;
            }
        }
        return false;
    }

    boolean canUseAsThoughManaToPayManaCost(ManaCost checkCost, Ability abilityToPay, Mana manaOption, Ability manaAbility, MageObject manaProducer, Game game) {
        ManaPoolItem possiblePoolItem;
        if (manaOption instanceof ConditionalMana) {
            ConditionalMana conditionalNetMana = (ConditionalMana)manaOption;
            possiblePoolItem = new ManaPoolItem(conditionalNetMana, manaAbility.getSourceObject(game), conditionalNetMana.getManaProducerOriginalId() != null ? conditionalNetMana.getManaProducerOriginalId() : manaAbility.getOriginalId());
        } else {
            possiblePoolItem = new ManaPoolItem(manaOption.getRed(), manaOption.getGreen(), manaOption.getBlue(), manaOption.getWhite(), manaOption.getBlack(), manaOption.getGeneric() + manaOption.getColorless(), manaProducer, manaAbility.getOriginalId(), manaOption.getFlag());
        }
        for (ManaType checkType : ManaUtil.getManaTypesInCost((ManaCost)checkCost)) {
            boolean canPay;
            ManaType possibleAsThoughPoolManaType = game.getContinuousEffects().asThoughMana(checkType, possiblePoolItem, abilityToPay.getSourceId(), abilityToPay, abilityToPay.getControllerId(), game);
            if (possibleAsThoughPoolManaType == null) continue;
            if (possibleAsThoughPoolManaType == ManaType.COLORLESS) {
                canPay = possiblePoolItem.count() > 0;
            } else {
                boolean bl = canPay = possiblePoolItem.get(possibleAsThoughPoolManaType) > 0;
            }
            if (!canPay) continue;
            return true;
        }
        return false;
    }

    private Abilities<ActivatedManaAbilityImpl> getManaAbilitiesSortedByManaCount(MageObject mageObject, Game game) {
        Abilities manaAbilities = mageObject.getAbilities().getAvailableActivatedManaAbilities(Zone.BATTLEFIELD, this.playerId, game);
        if (manaAbilities.size() > 1) {
            Collections.sort(manaAbilities, (a1, a2) -> {
                int a1Max = 0;
                for (Mana netMana : a1.getNetMana(game)) {
                    if (netMana.count() <= a1Max) continue;
                    a1Max = netMana.count();
                }
                int a2Max = 0;
                for (Mana netMana : a2.getNetMana(game)) {
                    if (netMana.count() <= a2Max) continue;
                    a2Max = netMana.count();
                }
                return CardUtil.overflowDec((int)a2Max, (int)a1Max);
            });
        }
        return manaAbilities;
    }

    private List<MageObject> getSortedProducers(ManaCosts<ManaCost> unpaid, Game game) {
        List<MageObject> unsorted = this.getAvailableManaProducers(game);
        unsorted.addAll(this.getAvailableManaProducersWithCost(game));
        HashMap<MageObject, Integer> scored = new HashMap<MageObject, Integer>();
        for (MageObject mageObject : unsorted) {
            int score = 0;
            block1: for (ManaCost cost : unpaid) {
                for (ActivatedManaAbilityImpl ability : mageObject.getAbilities().getAvailableActivatedManaAbilities(Zone.BATTLEFIELD, this.playerId, game)) {
                    for (Mana netMana : ability.getNetMana(game)) {
                        if (!cost.testPay(netMana)) continue;
                        ++score;
                        continue block1;
                    }
                }
            }
            if (score > 0) {
                score += mageObject.getAbilities().getAvailableActivatedManaAbilities(Zone.BATTLEFIELD, this.playerId, game).size();
                score += mageObject.getAbilities().getActivatedAbilities(Zone.BATTLEFIELD).size();
                if (!mageObject.getCardType(game).contains(CardType.LAND)) {
                    score += 2;
                } else if (mageObject.getCardType(game).contains(CardType.CREATURE)) {
                    score += 2;
                }
            }
            scored.put(mageObject, score);
        }
        return this.sortByValue(scored);
    }

    private List<MageObject> sortByValue(Map<MageObject, Integer> map) {
        LinkedList<Map.Entry<MageObject, Integer>> list = new LinkedList<Map.Entry<MageObject, Integer>>(map.entrySet());
        Collections.sort(list, Comparator.comparing(Map.Entry::getValue));
        ArrayList<MageObject> result = new ArrayList<MageObject>();
        for (Map.Entry entry : list) {
            result.add((MageObject)entry.getKey());
        }
        return result;
    }

    public int announceX(int min, int max, String message, Game game, Ability source, boolean isManaPay) {
        return this.makeChoiceAmount(min, max, game, source, isManaPay);
    }

    public void abort() {
        this.abort = true;
    }

    public void skip() {
    }

    public boolean chooseUse(Outcome outcome, String message, Ability source, Game game) {
        return this.chooseUse(outcome, message, null, null, null, source, game);
    }

    public boolean chooseUse(Outcome outcome, String message, String secondMessage, String trueText, String falseText, Ability source, Game game) {
        return outcome != Outcome.AIDontUseIt;
    }

    public boolean choose(Outcome outcome, Choice choice, Game game) {
        if (choice.getMessage() != null && (choice.getMessage().equals("Choose creature type") || choice.getMessage().equals("Choose a creature type")) && this.chooseCreatureType(outcome, choice, game)) {
            return true;
        }
        ManaCost unpaid = null;
        if (!this.lastUnpaidMana.isEmpty()) {
            unpaid = new ArrayList<ManaCost>(this.lastUnpaidMana.values()).get(this.lastUnpaidMana.size() - 1);
        }
        if (outcome == Outcome.PutManaInPool && unpaid != null && choice.isManaColorChoice()) {
            if (unpaid.containsColor(ColoredManaSymbol.W) && choice.getChoices().contains("White")) {
                choice.setChoice("White");
                return true;
            }
            if (unpaid.containsColor(ColoredManaSymbol.R) && choice.getChoices().contains("Red")) {
                choice.setChoice("Red");
                return true;
            }
            if (unpaid.containsColor(ColoredManaSymbol.G) && choice.getChoices().contains("Green")) {
                choice.setChoice("Green");
                return true;
            }
            if (unpaid.containsColor(ColoredManaSymbol.U) && choice.getChoices().contains("Blue")) {
                choice.setChoice("Blue");
                return true;
            }
            if (unpaid.containsColor(ColoredManaSymbol.B) && choice.getChoices().contains("Black")) {
                choice.setChoice("Black");
                return true;
            }
            if (unpaid.getMana().getColorless() > 0 && choice.getChoices().contains("Colorless")) {
                choice.setChoice("Colorless");
                return true;
            }
        }
        if (!choice.isChosen()) {
            choice.setRandomChoice();
        }
        return true;
    }

    protected boolean chooseCreatureType(Outcome outcome, Choice choice, Game game) {
        block6: {
            Card card;
            block7: {
                if (outcome != Outcome.Detriment) break block7;
                for (Permanent permanent : game.getBattlefield().getActivePermanents(this.getId(), game)) {
                    if (!game.getOpponents(this.getId(), true).contains(permanent.getControllerId()) || !permanent.getCardType(game).contains(CardType.CREATURE) || permanent.getSubtype(game).isEmpty() || !choice.getChoices().contains(((SubType)permanent.getSubtype(game).get(0)).toString())) continue;
                    choice.setChoice(((SubType)permanent.getSubtype(game).get(0)).toString());
                    break;
                }
                if (choice.isChosen()) break block6;
                for (UUID opponentId : game.getOpponents(this.getId(), true)) {
                    Player opponent = game.getPlayer(opponentId);
                    for (Card card2 : opponent.getGraveyard().getCards(game)) {
                        if (card2 == null || !card2.getCardType(game).contains(CardType.CREATURE) || card2.getSubtype(game).isEmpty() || !choice.getChoices().contains(((SubType)card2.getSubtype(game).get(0)).toString())) continue;
                        choice.setChoice(((SubType)card2.getSubtype(game).get(0)).toString());
                        break;
                    }
                    if (!choice.isChosen()) continue;
                    break block6;
                }
                break block6;
            }
            for (UUID cardId : this.getHand()) {
                card = game.getCard(cardId);
                if (card == null || !card.getCardType(game).contains(CardType.CREATURE) || card.getSubtype(game).isEmpty() || !choice.getChoices().contains(((SubType)card.getSubtype(game).get(0)).toString())) continue;
                choice.setChoice(((SubType)card.getSubtype(game).get(0)).toString());
                break;
            }
            if (!choice.isChosen()) {
                for (UUID cardId : this.getLibrary().getCardList()) {
                    card = game.getCard(cardId);
                    if (card == null || !card.getCardType(game).contains(CardType.CREATURE) || card.getSubtype(game).isEmpty() || !choice.getChoices().contains(((SubType)card.getSubtype(game).get(0)).toString())) continue;
                    choice.setChoice(((SubType)card.getSubtype(game).get(0)).toString());
                    break;
                }
            }
        }
        return choice.isChosen();
    }

    public boolean chooseTarget(Outcome outcome, Cards cards, TargetCard target, Ability source, Game game) {
        return this.makeChoice(outcome, (Target)target, source, game, cards);
    }

    public boolean choose(Outcome outcome, Cards cards, TargetCard target, Ability source, Game game) {
        return this.makeChoice(outcome, (Target)target, source, game, cards);
    }

    public boolean choosePile(Outcome outcome, String message, List<? extends Card> pile1, List<? extends Card> pile2, Game game) {
        return true;
    }

    public void selectAttackers(Game game, UUID attackingPlayerId) {
    }

    public void selectBlockers(Ability source, Game game, UUID defendingPlayerId) {
    }

    public int chooseReplacementEffect(Map<String, String> effectsMap, Map<String, MageObject> objectsMap, Game game) {
        return 0;
    }

    public Mode chooseMode(Modes modes, Ability source, Game game) {
        if (modes.getMode() != null && modes.getMaxModes(game, source) == modes.getSelectedModes().size()) {
            return modes.getMode();
        }
        return modes.getAvailableModes(source, game).stream().filter(mode -> !modes.getSelectedModes().contains(mode.getId())).filter(mode -> mode.getTargets().canChoose(source.getControllerId(), source, game)).findFirst().orElse(null);
    }

    public TriggeredAbility chooseTriggeredAbility(List<TriggeredAbility> abilities, Game game) {
        if (!abilities.isEmpty()) {
            return abilities.get(0);
        }
        return null;
    }

    public int getAmount(int min, int max, String message, Ability source, Game game) {
        return this.makeChoiceAmount(min, max, game, source, false);
    }

    public List<Integer> getMultiAmountWithIndividualConstraints(Outcome outcome, List<MultiAmountMessage> messages, int totalMin, int totalMax, MultiAmountType type, Game game) {
        int needCount = messages.size();
        List defaultList = MultiAmountType.prepareDefaultValues(messages, (int)totalMin, (int)totalMax);
        if (needCount == 0) {
            return defaultList;
        }
        if (!outcome.isGood()) {
            return defaultList;
        }
        return MultiAmountType.prepareMaxValues(messages, (int)totalMin, (int)totalMax);
    }

    public List<MageObject> getAvailableManaProducers(Game game) {
        return super.getAvailableManaProducers(game);
    }

    public void sideboard(Match match, Deck deck) {
        match.submitDeck(this.playerId, deck);
    }

    private static void addBasicLands(Deck deck, String landName, int number) {
        Set landSets = TournamentUtil.getLandSetCodeForDeckSets((Collection)deck.getExpansionSetCodes());
        CardCriteria criteria = new CardCriteria();
        if (!landSets.isEmpty()) {
            criteria.setCodes(landSets.toArray(new String[0]));
        }
        criteria.rarities(new Rarity[]{Rarity.LAND}).name(landName);
        List cards = CardRepository.instance.findCards(criteria);
        if (cards.isEmpty()) {
            criteria = new CardCriteria();
            criteria.rarities(new Rarity[]{Rarity.LAND}).name(landName);
            criteria.setCodes(new String[]{"M15"});
            cards = CardRepository.instance.findCards(criteria);
        }
        for (int i = 0; i < number; ++i) {
            Card land = ((CardInfo)cards.get(RandomUtil.nextInt((int)cards.size()))).createCard();
            deck.getCards().add(land);
        }
    }

    public static Deck buildDeck(int deckMinSize, List<Card> cardPool, List<ColoredManaSymbol> colors) {
        return ComputerPlayer.buildDeck(deckMinSize, cardPool, colors, false);
    }

    public static Deck buildDeck(int deckMinSize, List<Card> cardPool, List<ColoredManaSymbol> colors, boolean onlyBasicLands) {
        if (onlyBasicLands) {
            return ComputerPlayer.buildDeckWithOnlyBasicLands(deckMinSize, cardPool);
        }
        return ComputerPlayer.buildDeckWithNormalCards(deckMinSize, cardPool, colors);
    }

    public static Deck buildDeckWithOnlyBasicLands(int deckMinSize, List<Card> cardPool) {
        Deck deck = new Deck();
        int DECK_SIZE = deckMinSize != 0 ? deckMinSize : 40;
        ArrayList<Card> sortedCards = new ArrayList<Card>(cardPool);
        if (!sortedCards.isEmpty()) {
            while (deck.getMaindeckCards().size() < DECK_SIZE) {
                deck.getCards().add(sortedCards.get(RandomUtil.nextInt((int)sortedCards.size())));
            }
            return deck;
        }
        ComputerPlayer.addBasicLands(deck, "Forest", DECK_SIZE);
        return deck;
    }

    public static Deck buildDeckWithNormalCards(int deckMinSize, List<Card> cardPool, List<ColoredManaSymbol> colors) {
        int number;
        Deck deck = new Deck();
        int DECK_SIZE = deckMinSize != 0 ? deckMinSize : 40;
        int DECK_CARDS_COUNT = Math.floorDiv(deckMinSize * 23, 40);
        int DECK_LANDS_COUNT = DECK_SIZE - DECK_CARDS_COUNT;
        ArrayList<Card> sortedCards = new ArrayList<Card>(cardPool);
        Collections.sort(sortedCards, (o1, o2) -> {
            Integer score1 = RateCard.rateCard((Card)o1, (List)colors);
            Integer score2 = RateCard.rateCard((Card)o2, (List)colors);
            return score2.compareTo(score1);
        });
        for (int cardNum = 0; deck.getMaindeckCards().size() < DECK_CARDS_COUNT && sortedCards.size() > cardNum; ++cardNum) {
            Card card = (Card)sortedCards.get(cardNum);
            if (card.isBasic()) continue;
            deck.getCards().add(card);
            deck.getSideboard().remove(card);
        }
        Mana mana = new Mana();
        for (Card card : deck.getCards()) {
            mana.add(card.getManaCost().getMana());
        }
        double total = mana.getBlack() + mana.getBlue() + mana.getGreen() + mana.getRed() + mana.getWhite();
        int mostLand = 0;
        String mostLandName = "Forest";
        if (mana.getGreen() > 0) {
            number = (int)Math.round((double)mana.getGreen() / total * (double)DECK_LANDS_COUNT);
            ComputerPlayer.addBasicLands(deck, "Forest", number);
            mostLand = number;
        }
        if (mana.getBlack() > 0) {
            number = (int)Math.round((double)mana.getBlack() / total * (double)DECK_LANDS_COUNT);
            ComputerPlayer.addBasicLands(deck, "Swamp", number);
            if (number > mostLand) {
                mostLand = number;
                mostLandName = "Swamp";
            }
        }
        if (mana.getBlue() > 0) {
            number = (int)Math.round((double)mana.getBlue() / total * (double)DECK_LANDS_COUNT);
            ComputerPlayer.addBasicLands(deck, "Island", number);
            if (number > mostLand) {
                mostLand = number;
                mostLandName = "Island";
            }
        }
        if (mana.getWhite() > 0) {
            number = (int)Math.round((double)mana.getWhite() / total * (double)DECK_LANDS_COUNT);
            ComputerPlayer.addBasicLands(deck, "Plains", number);
            if (number > mostLand) {
                mostLand = number;
                mostLandName = "Plains";
            }
        }
        if (mana.getRed() > 0) {
            number = (int)Math.round((double)mana.getRed() / total * (double)DECK_LANDS_COUNT);
            ComputerPlayer.addBasicLands(deck, "Mountain", number);
            if (number > mostLand) {
                mostLandName = "Plains";
            }
        }
        ComputerPlayer.addBasicLands(deck, mostLandName, DECK_SIZE - deck.getMaindeckCards().size());
        return deck;
    }

    public void construct(Tournament tournament, Deck deck) {
        int deckMinSize;
        DeckValidator deckValidator = DeckValidatorFactory.instance.createDeckValidator(tournament.getOptions().getMatchOptions().getDeckType());
        int n = deckMinSize = deckValidator != null ? deckValidator.getDeckMinSize() : 0;
        if (deck != null && deck.getMaindeckCards().size() < deckMinSize && !deck.getSideboard().isEmpty()) {
            if (this.chosenColors.isEmpty()) {
                for (Card card : deck.getSideboard()) {
                    this.rememberPick(card, RateCard.rateCard((Card)card, Collections.emptyList()));
                }
                List<ColoredManaSymbol> deckColors = this.chooseDeckColorsIfPossible();
                if (deckColors != null) {
                    this.chosenColors.addAll(deckColors);
                }
            }
            deck = ComputerPlayer.buildDeck(deckMinSize, new ArrayList<Card>(deck.getSideboard()), this.chosenColors);
        }
        tournament.submitDeck(this.playerId, deck);
    }

    public Card makePickCard(List<Card> cards, List<ColoredManaSymbol> chosenColors) {
        if (cards.isEmpty()) {
            return null;
        }
        Card bestCard = null;
        int maxScore = 0;
        for (Card card : cards) {
            int score = RateCard.rateCard((Card)card, chosenColors);
            boolean betterCard = false;
            if (bestCard == null) {
                betterCard = true;
            } else if (score > maxScore) {
                betterCard = true;
            }
            if (!betterCard) continue;
            maxScore = score;
            bestCard = card;
        }
        return bestCard;
    }

    public void pickCard(List<Card> cards, Deck deck, Draft draft) {
        if (cards.isEmpty()) {
            throw new IllegalArgumentException("No cards to pick from.");
        }
        try {
            Card counterPick;
            int counterPickScore;
            Card bestCard = this.makePickCard(cards, this.chosenColors);
            int maxScore = RateCard.rateCard((Card)bestCard, this.chosenColors);
            int pickedCardRate = RateCard.getBaseCardScore((Card)bestCard);
            if (pickedCardRate <= 30 && (counterPickScore = RateCard.getBaseCardScore((Card)(counterPick = this.makePickCard(cards, Collections.emptyList())))) >= 80) {
                bestCard = counterPick;
                maxScore = RateCard.rateCard((Card)bestCard, this.chosenColors);
            }
            String colors = "not chosen yet";
            if (this.chosenColors.isEmpty()) {
                this.rememberPick(bestCard, maxScore);
                List<ColoredManaSymbol> chosen = this.chooseDeckColorsIfPossible();
                if (chosen != null) {
                    this.chosenColors.addAll(chosen);
                }
            }
            if (!this.chosenColors.isEmpty()) {
                colors = "";
                for (ColoredManaSymbol symbol : this.chosenColors) {
                    colors = colors + symbol.toString();
                }
            }
            draft.addPick(this.playerId, bestCard.getId(), null);
        }
        catch (Exception e) {
            logger.error((Object)("Error during AI pick card for draft playerId = " + this.getId()), (Throwable)e);
            draft.addPick(this.playerId, cards.get(0).getId(), null);
        }
    }

    protected void rememberPick(Card card, int score) {
        this.pickedCards.add(new PickedCard(card, score));
    }

    protected List<ColoredManaSymbol> chooseDeckColorsIfPossible() {
        if (this.pickedCards.size() > 2) {
            this.pickedCards.sort((o1, o2) -> {
                if (o1.score.equals(o2.score)) {
                    Integer i1 = RateCard.getColorManaCount((Card)o1.card);
                    Integer i2 = RateCard.getColorManaCount((Card)o2.card);
                    return i2.compareTo(i1);
                }
                return o2.score.compareTo(o1.score);
            });
            HashSet<String> chosenSymbols = new HashSet<String>();
            for (PickedCard picked : this.pickedCards) {
                int differentColorsInCost = RateCard.getDifferentColorManaCount((Card)picked.card);
                if (differentColorsInCost > 0 && differentColorsInCost < 3 && chosenSymbols.size() + differentColorsInCost < 4) {
                    for (String symbol : picked.card.getManaCostSymbols()) {
                        if (!RateCard.isColoredMana((String)(symbol = symbol.replace("{", "").replace("}", "")))) continue;
                        chosenSymbols.add(symbol);
                    }
                }
                if (chosenSymbols.size() <= 1 || chosenSymbols.size() >= 4) continue;
                ArrayList<ColoredManaSymbol> colorsChosen = new ArrayList<ColoredManaSymbol>();
                for (String symbol : chosenSymbols) {
                    ColoredManaSymbol manaSymbol = ColoredManaSymbol.lookup((char)symbol.charAt(0));
                    if (manaSymbol == null) continue;
                    colorsChosen.add(manaSymbol);
                }
                if (colorsChosen.size() <= 1) continue;
                this.pickedCards.clear();
                return colorsChosen;
            }
        }
        return null;
    }

    protected List<Permanent> remove(List<Permanent> source, Permanent element) {
        ArrayList<Permanent> newList = new ArrayList<Permanent>();
        for (Permanent permanent : source) {
            if (permanent.equals(element)) continue;
            newList.add(permanent);
        }
        return newList;
    }

    protected void logList(String message, List<MageObject> list) {
        StringBuilder sb = new StringBuilder();
        sb.append(message).append(": ");
        for (MageObject object : list) {
            sb.append(object.getName()).append(',');
        }
        logger.info((Object)sb.toString());
    }

    public void cleanUpOnMatchEnd() {
        super.cleanUpOnMatchEnd();
    }

    public ComputerPlayer copy() {
        return new ComputerPlayer(this);
    }

    public SpellAbility chooseAbilityForCast(Card card, Game game, boolean noMana) {
        Map usable = PlayerImpl.getCastableSpellAbilities((Game)game, (UUID)this.getId(), (MageObject)card, (Zone)game.getState().getZone(card.getId()), (boolean)noMana);
        return usable.values().stream().filter(a -> a.getTargets().canChoose(this.getId(), (Ability)a, game)).findFirst().orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Player obj = (Player)o;
        if (this.getId() == null || obj.getId() == null) {
            return false;
        }
        return this.getId().equals(obj.getId());
    }

    public boolean isHuman() {
        if (this.human) {
            throw new IllegalStateException("Computer player can't be Human");
        }
        return false;
    }

    public void restore(Player player) {
        super.restore(player);
        this.human = false;
    }

    private static class PickedCard {
        public Card card;
        public Integer score;

        public PickedCard(Card card, int score) {
            this.card = card;
            this.score = score;
        }
    }
}

