/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai.score;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.player.ai.score.MagicAbility;

public final class ArtificialScoringSystem {
    public static final int WIN_GAME_SCORE = 100000000;
    public static final int LOSE_GAME_SCORE = -100000000;
    private static final int[] LIFE_SCORES = new int[]{0, 1000, 2000, 3000, 4000, 4500, 5000, 5500, 6000, 6500, 7000, 7400, 7800, 8200, 8600, 9000, 9200, 9400, 9600, 9800, 10000};
    private static final int MAX_LIFE = LIFE_SCORES.length - 1;
    private static final int UNKNOWN_CARD_SCORE = 300;
    private static final int PERMANENT_SCORE = 300;
    private static final int LIFE_ABOVE_MULTIPLIER = 100;

    public static int getCardDefinitionScore(Game game, Card card) {
        int value = 3;
        if (card.isLand(game)) {
            int score = (int)((float)value / 2.0f * 50.0f);
            return score += card.getMana().size() * 50;
        }
        int score = value * 100 - card.getManaCost().manaValue() * 20;
        if (card.getCardType(game).contains(CardType.CREATURE)) {
            return score + (card.getPower().getValue() + card.getToughness().getValue()) * 10;
        }
        return score + (card.getRarity() == null ? 0 : card.getRarity().getRating() * 30);
    }

    public static int getFixedPermanentScore(Game game, Permanent permanent) {
        int score = ArtificialScoringSystem.getCardDefinitionScore(game, (Card)permanent);
        score += 300;
        if (!permanent.getCardType(game).contains(CardType.CREATURE) && permanent.hasSubtype(SubType.EQUIPMENT, game)) {
            score += 100;
        }
        return score;
    }

    public static int getDynamicPermanentScore(Game game, Permanent permanent) {
        int score = permanent.getCounters(game).getCount(CounterType.CHARGE) * 30;
        score += permanent.getCounters(game).getCount(CounterType.LEVEL) * 30;
        score -= permanent.getDamage() * 2;
        if (permanent.getCardType(game).contains(CardType.CREATURE)) {
            int power = permanent.getPower().getValue();
            int toughness = permanent.getToughness().getValue();
            int abilityScore = 0;
            for (Ability ability : permanent.getAbilities(game)) {
                abilityScore += MagicAbility.getAbilityScore(ability);
            }
            score += power * 300 + ArtificialScoringSystem.getPositive(toughness) * 200 + abilityScore * (ArtificialScoringSystem.getPositive(power) + 1) / 2;
            int enchantments = 0;
            int equipments = 0;
            for (UUID uuid : permanent.getAttachments()) {
                MageObject object = game.getObject(uuid);
                if (!(object instanceof Card)) continue;
                Card card = (Card)object;
                int outcomeScore = card.getAbilities(game).getOutcomeTotal();
                if (card.getCardType(game).contains(CardType.ENCHANTMENT)) {
                    enchantments += outcomeScore * 100;
                    continue;
                }
                equipments += outcomeScore * 50;
            }
            score += equipments + enchantments;
        }
        return score;
    }

    public static int getCombatPermanentScore(Game game, Permanent permanent) {
        int score = 0;
        if (!ArtificialScoringSystem.canTap(game, permanent)) {
            score += ArtificialScoringSystem.getTappedScore(game, permanent);
        }
        if (permanent.getCardType(game).contains(CardType.CREATURE)) {
            if (!permanent.canAttack(null, game)) {
                score -= 100;
            }
            if (!permanent.canBlockAny(game)) {
                score -= 30;
            }
        }
        return score;
    }

    private static boolean canTap(Game game, Permanent permanent) {
        return !permanent.isTapped() && (!permanent.hasSummoningSickness() || !permanent.getCardType(game).contains(CardType.CREATURE) || permanent.getAbilities(game).contains((Ability)HasteAbility.getInstance()));
    }

    private static int getPositive(int value) {
        return Math.max(0, value);
    }

    public static int getTappedScore(Game game, Permanent permanent) {
        if (permanent.isCreature(game)) {
            return -100;
        }
        if (permanent.isLand(game)) {
            return -20;
        }
        return -2;
    }

    public static int getLifeScore(int life) {
        if (life > MAX_LIFE) {
            return LIFE_SCORES[MAX_LIFE] + (life - MAX_LIFE) * 100;
        }
        if (life >= 0) {
            return LIFE_SCORES[life];
        }
        return 0;
    }

    public static int getManaScore(int amount) {
        return -amount;
    }

    public static int getAttackerScore(Permanent attacker) {
        int score = 0;
        return score;
    }
}

