/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai.score;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.player.ai.score.ArtificialScoringSystem;
import mage.players.Player;
import org.apache.log4j.Logger;

public final class GameStateEvaluator2 {
    private static final Logger logger = Logger.getLogger(GameStateEvaluator2.class);
    public static final int WIN_GAME_SCORE = 100000000;
    public static final int LOSE_GAME_SCORE = -100000000;
    public static final int HAND_CARD_SCORE = 5;

    public static PlayerEvaluateScore evaluate(UUID playerId, Game game) {
        return GameStateEvaluator2.evaluate(playerId, game, true);
    }

    public static PlayerEvaluateScore evaluate(UUID playerId, Game game, boolean useCombatPermanentScore) {
        Player player = game.getPlayer(playerId);
        Player opponent = game.getPlayer((UUID)game.getOpponents(playerId, false).stream().findFirst().orElse(null));
        if (opponent == null) {
            return new PlayerEvaluateScore(playerId, 100000000);
        }
        if (game.checkIfGameIsOver()) {
            if (player.hasLost() || opponent.hasWon()) {
                return new PlayerEvaluateScore(playerId, -100000000);
            }
            if (opponent.hasLost() || player.hasWon()) {
                return new PlayerEvaluateScore(playerId, 100000000);
            }
        }
        int playerLifeScore = 0;
        int opponentLifeScore = 0;
        if (player.getLife() <= 0) {
            playerLifeScore = -100000000;
        } else if (opponent.getLife() <= 0) {
            playerLifeScore = 100000000;
        } else {
            playerLifeScore = ArtificialScoringSystem.getLifeScore(player.getLife());
            opponentLifeScore = ArtificialScoringSystem.getLifeScore(opponent.getLife());
        }
        int playerPermanentsScore = 0;
        int opponentPermanentsScore = 0;
        try {
            int onePermScore;
            StringBuilder sbPlayer = new StringBuilder();
            StringBuilder sbOpponent = new StringBuilder();
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(playerId)) {
                onePermScore = GameStateEvaluator2.evaluatePermanent(permanent, game, useCombatPermanentScore);
                playerPermanentsScore += onePermScore;
                if (!logger.isDebugEnabled()) continue;
                sbPlayer.append(permanent.getName()).append('[').append(onePermScore).append("] ");
            }
            if (logger.isDebugEnabled()) {
                sbPlayer.insert(0, playerPermanentsScore + " - ");
                sbPlayer.insert(0, "Player..: ");
                logger.debug((Object)sbPlayer);
            }
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(opponent.getId())) {
                onePermScore = GameStateEvaluator2.evaluatePermanent(permanent, game, useCombatPermanentScore);
                opponentPermanentsScore += onePermScore;
                if (!logger.isDebugEnabled()) continue;
                sbOpponent.append(permanent.getName()).append('[').append(onePermScore).append("] ");
            }
            if (logger.isDebugEnabled()) {
                sbOpponent.insert(0, opponentPermanentsScore + " - ");
                sbOpponent.insert(0, "Opponent: ");
                logger.debug((Object)sbOpponent);
            }
        }
        catch (Throwable sbPlayer) {
            // empty catch block
        }
        int playerHandScore = player.getHand().size() * 5;
        int opponentHandScore = opponent.getHand().size() * 5;
        int score = playerLifeScore - opponentLifeScore + (playerPermanentsScore - opponentPermanentsScore) + (playerHandScore - opponentHandScore);
        logger.debug((Object)(score + " total Score (life:" + (playerLifeScore - opponentLifeScore) + " permanents:" + (playerPermanentsScore - opponentPermanentsScore) + " hand:" + (playerHandScore - opponentHandScore) + ')'));
        return new PlayerEvaluateScore(playerId, playerLifeScore, playerHandScore, playerPermanentsScore, opponentLifeScore, opponentHandScore, opponentPermanentsScore);
    }

    public static int evaluatePermanent(Permanent permanent, Game game, boolean useCombatPermanentScore) {
        int value = 0;
        if (!permanent.getAttachments().isEmpty()) {
            for (UUID attachmentId : permanent.getAttachments()) {
                Permanent attachment = game.getPermanent(attachmentId);
                for (Ability a : attachment.getAbilities(game)) {
                    for (Effect e : a.getEffects()) {
                        if (!e.getOutcome().equals((Object)Outcome.Detriment) || !attachment.getControllerId().equals(permanent.getControllerId())) continue;
                        value -= 1000;
                    }
                }
            }
        }
        value += ArtificialScoringSystem.getFixedPermanentScore(game, permanent);
        value += ArtificialScoringSystem.getDynamicPermanentScore(game, permanent);
        if (useCombatPermanentScore) {
            value += ArtificialScoringSystem.getCombatPermanentScore(game, permanent);
        }
        return value;
    }

    public static class PlayerEvaluateScore {
        private UUID playerId;
        private int playerLifeScore = 0;
        private int playerHandScore = 0;
        private int playerPermanentsScore = 0;
        private int opponentLifeScore = 0;
        private int opponentHandScore = 0;
        private int opponentPermanentsScore = 0;
        private int specialScore = 0;

        public PlayerEvaluateScore(UUID playerId, int specialScore) {
            this.playerId = playerId;
            this.specialScore = specialScore;
        }

        public PlayerEvaluateScore(UUID playerId, int playerLifeScore, int playerHandScore, int playerPermanentsScore, int opponentLifeScore, int opponentHandScore, int opponentPermanentsScore) {
            this.playerId = playerId;
            this.playerLifeScore = playerLifeScore;
            this.playerHandScore = playerHandScore;
            this.playerPermanentsScore = playerPermanentsScore;
            this.opponentLifeScore = opponentLifeScore;
            this.opponentHandScore = opponentHandScore;
            this.opponentPermanentsScore = opponentPermanentsScore;
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public int getPlayerScore() {
            return this.playerLifeScore + this.playerHandScore + this.playerPermanentsScore;
        }

        public int getOpponentScore() {
            return this.opponentLifeScore + this.opponentHandScore + this.opponentPermanentsScore;
        }

        public int getTotalScore() {
            if (this.specialScore != 0) {
                return this.specialScore;
            }
            return this.getPlayerScore() - this.getOpponentScore();
        }

        public int getPlayerLifeScore() {
            return this.playerLifeScore;
        }

        public int getPlayerHandScore() {
            return this.playerHandScore;
        }

        public int getPlayerPermanentsScore() {
            return this.playerPermanentsScore;
        }

        public String getPlayerInfoFull() {
            return "Life:" + this.playerLifeScore + ", Hand:" + this.playerHandScore + ", Perm:" + this.playerPermanentsScore;
        }

        public String getPlayerInfoShort() {
            return "L:" + this.playerLifeScore + ",H:" + this.playerHandScore + ",P:" + this.playerPermanentsScore;
        }

        public String getOpponentInfoFull() {
            return "Life:" + this.opponentLifeScore + ", Hand:" + this.opponentHandScore + ", Perm:" + this.opponentPermanentsScore;
        }

        public String getOpponentInfoShort() {
            return "L:" + this.opponentLifeScore + ",H:" + this.opponentHandScore + ",P:" + this.opponentPermanentsScore;
        }
    }
}

