/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import org.jetlang.channels.Subscribable;
import org.jetlang.core.DisposingExecutor;
import org.jetlang.core.Filter;

public abstract class BaseSubscription<T>
implements Subscribable<T> {
    private final Filter<T> _filter;
    private final DisposingExecutor fiber;

    public BaseSubscription(DisposingExecutor fiber) {
        this.fiber = fiber;
        this._filter = null;
    }

    protected BaseSubscription(DisposingExecutor fiber, Filter<T> _filter) {
        this._filter = _filter;
        this.fiber = fiber;
    }

    @Override
    public DisposingExecutor getQueue() {
        return this.fiber;
    }

    @Override
    public void onMessage(T msg) {
        if (this._filter == null || this._filter.passes(msg)) {
            this.onMessageOnProducerThread(msg);
        }
    }

    protected abstract void onMessageOnProducerThread(T var1);
}

