/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetlang.channels.BaseSubscription;
import org.jetlang.core.Callback;
import org.jetlang.core.Filter;
import org.jetlang.fibers.Fiber;

public class BatchSubscriber<T>
extends BaseSubscription<T> {
    private final Object _lock = new Object();
    private final Fiber _queue;
    private final Callback<List<T>> _receive;
    private final int _interval;
    private final TimeUnit _timeUnit;
    private List<T> _pending;
    private final Runnable _flushRunnable;

    public BatchSubscriber(Fiber queue, Callback<List<T>> receive, Filter<T> filter, int interval, TimeUnit timeUnit) {
        super(queue, filter);
        this._queue = queue;
        this._receive = receive;
        this._interval = interval;
        this._timeUnit = timeUnit;
        this._flushRunnable = new Runnable(){

            @Override
            public void run() {
                BatchSubscriber.this.flush();
            }

            public String toString() {
                return "Flushing " + BatchSubscriber.this + " via " + BatchSubscriber.this._receive.toString();
            }
        };
    }

    public BatchSubscriber(Fiber queue, Callback<List<T>> receive, int interval, TimeUnit timeUnit) {
        this(queue, receive, null, interval, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onMessageOnProducerThread(T msg) {
        Object object = this._lock;
        synchronized (object) {
            if (this._pending == null) {
                this._pending = new ArrayList<T>();
                this._queue.schedule(this._flushRunnable, this._interval, this._timeUnit);
            }
            this._pending.add(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        List<T> toFlush = null;
        Object object = this._lock;
        synchronized (object) {
            if (this._pending != null) {
                toFlush = this._pending;
                this._pending = null;
            }
        }
        if (toFlush != null) {
            this._receive.onMessage(toFlush);
        }
    }
}

