/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetlang.channels.BaseSubscription;
import org.jetlang.channels.Converter;
import org.jetlang.core.Callback;
import org.jetlang.core.Filter;
import org.jetlang.fibers.Fiber;

public class KeyedBatchSubscriber<K, T>
extends BaseSubscription<T> {
    private final Object _batchLock = new Object();
    private final Fiber _context;
    private final Callback<Map<K, T>> _target;
    private final int _flushIntervalInMs;
    private final TimeUnit _timeUnit;
    private final Converter<T, K> _keyResolver;
    private Map<K, T> _pending = null;
    private final Runnable _flushRunner;

    public KeyedBatchSubscriber(Fiber context, Callback<Map<K, T>> target, Filter<T> filter, int flushIntervalInMs, TimeUnit timeUnit, Converter<T, K> keyResolver) {
        super(context, filter);
        this._keyResolver = keyResolver;
        this._context = context;
        this._target = target;
        this._flushIntervalInMs = flushIntervalInMs;
        this._timeUnit = timeUnit;
        this._flushRunner = new Runnable(){

            @Override
            public void run() {
                KeyedBatchSubscriber.this.flush();
            }

            public String toString() {
                return "Flushing " + KeyedBatchSubscriber.this + " via " + KeyedBatchSubscriber.this._target.toString();
            }
        };
    }

    public KeyedBatchSubscriber(Fiber context, Callback<Map<K, T>> target, int flushIntervalInMs, TimeUnit timeUnit, Converter<T, K> keyResolver) {
        this(context, target, null, flushIntervalInMs, timeUnit, keyResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onMessageOnProducerThread(T msg) {
        Object object = this._batchLock;
        synchronized (object) {
            K key = this._keyResolver.convert(msg);
            if (this._pending == null) {
                this._pending = new HashMap<K, T>();
                this._context.schedule(this._flushRunner, this._flushIntervalInMs, this._timeUnit);
            }
            this._pending.put(key, msg);
        }
    }

    private void flush() {
        Map<K, T> toReturn = this.clearPending();
        if (toReturn != null) {
            this._target.onMessage(toReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, T> clearPending() {
        Object object = this._batchLock;
        synchronized (object) {
            if (this._pending == null || this._pending.isEmpty()) {
                this._pending = null;
                return null;
            }
            Map<K, T> toReturn = this._pending;
            this._pending = null;
            return toReturn;
        }
    }
}

