/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import java.util.concurrent.TimeUnit;
import org.jetlang.channels.BaseSubscription;
import org.jetlang.core.Callback;
import org.jetlang.core.Filter;
import org.jetlang.fibers.Fiber;

public class LastSubscriber<T>
extends BaseSubscription<T> {
    private final Object _lock = new Object();
    private final Fiber _context;
    private final Callback<T> _target;
    private final int _flushIntervalInMs;
    private final TimeUnit _timeUnit;
    private boolean _flushPending;
    private T _pending;
    private final Runnable _flushRunnable;

    public LastSubscriber(Fiber context, Callback<T> target, Filter<T> filter, int flushInterval, TimeUnit timeUnit) {
        super(context, filter);
        this._context = context;
        this._target = target;
        this._flushIntervalInMs = flushInterval;
        this._timeUnit = timeUnit;
        this._flushRunnable = new Runnable(){

            @Override
            public void run() {
                LastSubscriber.this.flush();
            }

            public String toString() {
                return "Flushing " + LastSubscriber.this + " via " + LastSubscriber.this._target.toString();
            }
        };
    }

    public LastSubscriber(Fiber context, Callback<T> target, int flushInterval, TimeUnit timeUnit) {
        this(context, target, null, flushInterval, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onMessageOnProducerThread(T msg) {
        Object object = this._lock;
        synchronized (object) {
            if (!this._flushPending) {
                this._flushPending = true;
                if (this._flushIntervalInMs < 1) {
                    this._context.execute(this._flushRunnable);
                } else {
                    this._context.schedule(this._flushRunnable, this._flushIntervalInMs, this._timeUnit);
                }
            }
            this._pending = msg;
        }
    }

    private void flush() {
        T toReturn = this.clearPending();
        this._target.onMessage(toReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T clearPending() {
        Object object = this._lock;
        synchronized (object) {
            this._flushPending = false;
            return this._pending;
        }
    }
}

