/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import org.jetlang.channels.Channel;
import org.jetlang.channels.ChannelSubscription;
import org.jetlang.channels.Subscribable;
import org.jetlang.channels.SubscriberList;
import org.jetlang.core.Callback;
import org.jetlang.core.Disposable;
import org.jetlang.core.DisposingExecutor;

public class MemoryChannel<T>
implements Channel<T> {
    private final SubscriberList<T> _subscribers = new SubscriberList();

    public int subscriberCount() {
        return this._subscribers.size();
    }

    @Override
    public void publish(T s) {
        this._subscribers.publish(s);
    }

    @Override
    public Disposable subscribe(DisposingExecutor queue, Callback<T> onReceive) {
        ChannelSubscription<T> subber = new ChannelSubscription<T>(queue, onReceive);
        return this.subscribe(subber);
    }

    @Override
    public Disposable subscribe(Subscribable<T> sub) {
        return this.subscribeOnProducerThread(sub.getQueue(), sub);
    }

    public Disposable subscribeOnProducerThread(final DisposingExecutor queue, final Callback<T> callbackOnQueue) {
        Disposable unSub = new Disposable(){

            @Override
            public void dispose() {
                MemoryChannel.this.remove(callbackOnQueue);
                queue.remove(this);
            }
        };
        queue.add(unSub);
        this._subscribers.add(callbackOnQueue);
        return unSub;
    }

    private void remove(Callback<T> callbackOnQueue) {
        this._subscribers.remove(callbackOnQueue);
    }

    public void clearSubscribers() {
        this._subscribers.clear();
    }
}

