/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetlang.channels.AsyncRequest;
import org.jetlang.channels.RequestChannel;
import org.jetlang.core.Callback;
import org.jetlang.core.Disposable;
import org.jetlang.fibers.Fiber;

class SingleReply {
    SingleReply() {
    }

    public static <R, V> Disposable publish(Fiber fiber, RequestChannel<R, V> channel, R request, final Callback<V> reply) {
        AsyncRequest<R, V> async = new AsyncRequest<R, V>(fiber);
        async.setResponseCount(1);
        Callback onMsg = new Callback<List<V>>(){

            @Override
            public void onMessage(List<V> message) {
                reply.onMessage(message.get(0));
            }
        };
        return async.publish(channel, request, onMsg);
    }

    public static <R, V> Disposable publish(Fiber fiber, RequestChannel<R, V> channel, R request, final Callback<V> reply, long timeout, TimeUnit unit, final Runnable onTimeout) {
        AsyncRequest<R, V> async = new AsyncRequest<R, V>(fiber);
        async.setResponseCount(1);
        Callback onListTimeout = new Callback<List<V>>(){

            @Override
            public void onMessage(List<V> message) {
                onTimeout.run();
            }
        };
        async.setTimeout(onListTimeout, timeout, unit);
        Callback onMsg = new Callback<List<V>>(){

            @Override
            public void onMessage(List<V> message) {
                reply.onMessage(message.get(0));
            }
        };
        return async.publish(channel, request, onMsg);
    }
}

