/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import org.jetlang.core.EventBuffer;

public class NioQueueSwapper {
    private final Pipe.SinkChannel sink;
    private final ByteBuffer pingByte = ByteBuffer.allocateDirect(1);
    private EventBuffer _queue = new EventBuffer();
    private boolean running = true;

    public NioQueueSwapper(Pipe.SinkChannel sink) {
        this.sink = sink;
        this.pingByte.limit(1);
    }

    public synchronized void put(Runnable r) {
        if (!this.running) {
            return;
        }
        this._queue.add(r);
        if (this._queue.size() == 1) {
            this.pingByte.position(0);
            try {
                this.sink.write(this.pingByte);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized EventBuffer swap(EventBuffer buffer) {
        EventBuffer toReturn = this._queue;
        this._queue = buffer;
        return toReturn;
    }

    public synchronized int size() {
        return this._queue.size();
    }

    public synchronized void setRunning(boolean running) {
        this.running = running;
    }
}

