/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetlang.core.BatchExecutor;
import org.jetlang.core.BatchExecutorImpl;
import org.jetlang.core.Disposable;
import org.jetlang.core.EventBuffer;
import org.jetlang.core.EventQueue;
import org.jetlang.core.RunnableBlockingQueue;
import org.jetlang.core.RunnableExecutor;

public class RunnableExecutorImpl
implements RunnableExecutor {
    private final EventQueue _commands;
    private final List<Disposable> _disposables = Collections.synchronizedList(new ArrayList());
    private final BatchExecutor _commandExecutor;

    public RunnableExecutorImpl() {
        this(new BatchExecutorImpl());
    }

    public RunnableExecutorImpl(BatchExecutor executor) {
        this(executor, new RunnableBlockingQueue());
    }

    public RunnableExecutorImpl(BatchExecutor exec, EventQueue q) {
        this._commands = q;
        this._commandExecutor = exec;
    }

    @Override
    public void execute(Runnable command) {
        this._commands.put(command);
    }

    @Override
    public void run() {
        EventBuffer buffer = new EventBuffer();
        while (this._commands.isRunning()) {
            buffer = this._commands.swap(buffer);
            this._commandExecutor.execute(buffer);
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this._commands.setRunning(false);
        this.execute(new Runnable(){

            @Override
            public void run() {
            }
        });
        List<Disposable> list = this._disposables;
        synchronized (list) {
            for (Disposable r : this._disposables.toArray(new Disposable[this._disposables.size()])) {
                r.dispose();
            }
        }
    }

    @Override
    public void add(Disposable r) {
        this._disposables.add(r);
    }

    @Override
    public boolean remove(Disposable disposable) {
        return this._disposables.remove(disposable);
    }

    @Override
    public int size() {
        return this._disposables.size();
    }
}

