/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.core;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetlang.core.DaemonThreadFactory;
import org.jetlang.core.Disposable;
import org.jetlang.core.DisposingExecutor;
import org.jetlang.core.Scheduler;

public class SchedulerImpl
implements Scheduler {
    private final ScheduledExecutorService _scheduler;
    private final Executor _queue;

    public SchedulerImpl(Executor queue, ScheduledExecutorService service) {
        this._queue = queue;
        this._scheduler = service;
    }

    public SchedulerImpl(Executor queue) {
        this(queue, (ScheduledExecutorService)SchedulerImpl.createSchedulerThatIgnoresEventsAfterStop());
    }

    public static ScheduledThreadPoolExecutor createSchedulerThatIgnoresEventsAfterStop() {
        DaemonThreadFactory fact = new DaemonThreadFactory();
        return SchedulerImpl.createSchedulerThatIgnoresEventsAfterStop(fact);
    }

    public static ScheduledThreadPoolExecutor createSchedulerThatIgnoresEventsAfterStop(ThreadFactory fact) {
        ScheduledThreadPoolExecutor s = new ScheduledThreadPoolExecutor(1, fact);
        s.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        s.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        RejectedExecutionHandler handler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    throw new RejectedExecutionException("Rejected Execution: " + r);
                }
            }
        };
        s.setRejectedExecutionHandler(handler);
        return s;
    }

    public SchedulerImpl(DisposingExecutor queue, ScheduledExecutorService scheduler) {
        this._queue = queue;
        this._scheduler = scheduler;
    }

    @Override
    public Disposable schedule(Runnable _command, long delay, TimeUnit unit) {
        if (delay == 0L) {
            PendingCommand c = new PendingCommand(_command);
            this._queue.execute(c);
            return c;
        }
        PendingCommand command = new PendingCommand(_command);
        return new ScheduledFutureControl(this._scheduler.schedule(new ExecuteCommand(command), delay, unit), command);
    }

    @Override
    public Disposable scheduleAtFixedRate(Runnable _command, long initialDelay, long interval, TimeUnit unit) {
        PendingCommand command = new PendingCommand(_command);
        return new ScheduledFutureControl(this._scheduler.scheduleAtFixedRate(new ExecuteCommand(command), initialDelay, interval, unit), command);
    }

    @Override
    public Disposable scheduleWithFixedDelay(Runnable command, long initialDelay, long interval, TimeUnit unit) {
        FixedDelayTask fixedDelayTask = new FixedDelayTask(command, interval, unit);
        fixedDelayTask.scheduledEvent = this.schedule(fixedDelayTask, initialDelay, unit);
        return fixedDelayTask;
    }

    @Override
    public void dispose() {
        this._scheduler.shutdown();
    }

    private final class ScheduledFutureControl
    implements Disposable {
        private final ScheduledFuture<?> future;
        private final Disposable command;

        public ScheduledFutureControl(ScheduledFuture<?> future, Disposable command) {
            this.future = future;
            this.command = command;
        }

        @Override
        public void dispose() {
            this.command.dispose();
            this.future.cancel(false);
        }
    }

    private static class PendingCommand
    implements Disposable,
    Runnable {
        private final Runnable _toExecute;
        private volatile boolean _cancelled;

        public PendingCommand(Runnable toExecute) {
            this._toExecute = toExecute;
        }

        @Override
        public void dispose() {
            this._cancelled = true;
        }

        @Override
        public void run() {
            if (!this._cancelled) {
                this._toExecute.run();
            }
        }

        public String toString() {
            return this._toExecute.toString();
        }
    }

    private class ExecuteCommand
    implements Runnable {
        private final Runnable command;

        public ExecuteCommand(Runnable command) {
            this.command = command;
        }

        @Override
        public void run() {
            SchedulerImpl.this._queue.execute(this.command);
        }

        public String toString() {
            return this.command.toString();
        }
    }

    private class FixedDelayTask
    implements Runnable,
    Disposable {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final Runnable target;
        private final long interval;
        private final TimeUnit unit;
        private volatile Disposable scheduledEvent;

        public FixedDelayTask(Runnable target, long interval, TimeUnit unit) {
            this.target = target;
            this.interval = interval;
            this.unit = unit;
        }

        @Override
        public void dispose() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.scheduledEvent.dispose();
            }
        }

        @Override
        public void run() {
            if (this.cancelled.get()) {
                return;
            }
            try {
                this.target.run();
            }
            finally {
                if (!this.cancelled.get()) {
                    this.scheduledEvent = SchedulerImpl.this.schedule(this, this.interval, this.unit);
                }
            }
        }

        public String toString() {
            return this.target.toString();
        }
    }
}

