/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetlang.core.Disposable;
import org.jetlang.core.RunnableExecutor;

public class SynchronousDisposingExecutor
implements RunnableExecutor {
    private final List<Disposable> _onStop = Collections.synchronizedList(new ArrayList());
    private volatile boolean _running = true;

    @Override
    public void execute(Runnable command) {
        if (this._running) {
            command.run();
        }
    }

    @Override
    public void add(Disposable runOnStop) {
        this._onStop.add(runOnStop);
    }

    @Override
    public boolean remove(Disposable disposable) {
        return this._onStop.remove(disposable);
    }

    @Override
    public int size() {
        return this._onStop.size();
    }

    @Override
    public void run() {
        this._running = true;
    }

    @Override
    public void dispose() {
        this._running = false;
        for (Disposable run : new ArrayList<Disposable>(this._onStop)) {
            run.dispose();
        }
    }
}

